import os
from pydantic.v1 import BaseSettings
from dotenv import load_dotenv

load_dotenv()


class Configuration(BaseSettings):
    MONGO_URI: str = os.getenv("MONGO_URI") or ""
    SRM_HOST: str = os.getenv("SRM_HOST") or ""
    PI_EDGE_USERNAME: str = os.getenv("PI_EDGE_USERNAME") or ""
    PI_EDGE_PASSWORD: str = os.getenv("PI_EDGE_PASSWORD") or ""
    HTTP_PROXY: str = os.getenv("HTTP_PROXY") or ""
    FEDERATION_MANAGER_HOST: str = os.getenv("FEDERATION_MANAGER_HOST") or ""


config = Configuration()
