# Open Exposure Gateway

The **Open Exposure Gateway (OEG)** is a Python web service implementation. It implements the **Open Exposure Gateway** role of the Operator Platform, defined by the [GSMA Operator Platform Group (OPG)](https://www.gsma.com/solutions-and-impact/technologies/networks/gsma-operator-platform-group-september-2024-publications/). 

### Overview


[![Edge Cloud Management API](https://labs.etsi.org/rep/oop/code/open-exposure-gateway/badges/dev-branch/pipeline.svg)](https://labs.etsi.org/rep/oop/code/open-exposure-gateway/-/pipelines)

This server was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.
It uses the [Connexion](https://github.com/zalando/connexion) library on top of Flask.
It propagates requests to the [Sunrise 6G OP service resource manager](https://github.com/OpenOperatorPlatform/service_resource_manager), as configured in the `.env`.

OEG implements the **Northbound CAMARA APIs** for application providers to interact with different infrastructures, including:

- Application metadata lifecycle management (registering, retrieving, deleting apps)
- Application instantiation management (instantation, and termination)
- Federation Management APIs to onboard applications accross partners' operator platforms

OEG acts as a middleware layer between the CAMARA APIs and the Service Resource Manager (SRM), by enabling a common exposure of heteregeneous infrastructure resources.

<br>

| Edge Cloud Management API  | Federation Management API | Network Exposure API  (QoD & Traffic Influence)|
| ------------- | ------------- |
| Application Metadata registration  | Create one direction federation   | Create QoD Session | 
| App Metadata Removal  | Retrieve details about federation with the partner OP  | Remove QoD Session  | 
| App Metadata Retrieval  | Retrieve the existing federationContextId with partner  | Retrieve QoD Session  |
| Application Instantiation  | Remove existing federation with partner OP | Create TrafficeInfluence Resource  |
| Application Instance Retrieval |                                        | Remove TrafficeInfluence Resource  |
| Application Instance Removal  |                                         | Retrieve TrafficeInfluence Resource  |


### Usage
Before running the server you need to `mv env.sample .env` and update variables to properly link to a running OP service resource manager instance.

To run the server, please execute the following from the root directory:

Using uv: 
```bash
# run the server as module - uv will automatically take care of any dependencies installation
uv run edge_cloud_management_api
```
and open your browser to the OpenAPI documentation: `http://127.0.0.1:8080/docs/`

### Testing

To launch the integration tests, use tox:
```bash
uv run tox
```

### Running with Docker

To run the server on a Docker container, please execute the following from the root directory:

```bash
# building the image
docker build -t edge_cloud_management_api .

# starting up a container
docker run -p 8080:8080 --env-file ./.env edge_cloud_management_api
```
