#!/bin/bash

# Nombre del contenedor e imagen
CONTAINER_NAME=capif-sdk-runner
IMAGE_NAME=opencapif_sdk
BRANCH_NAME=SDK15-create-dockerfile-image-with-sdk
NETWORK_NAME=capif-network

echo "🛠️ Building image: $IMAGE_NAME from branch: $BRANCH_NAME with no cache..."
docker build --no-cache . -t $IMAGE_NAME -f ci_cd_test/Dockerfile --build-arg BRANCH=$BRANCH_NAME

echo "🚀 Running container: $CONTAINER_NAME in network: $NETWORK_NAME..."
docker run \
  --name $CONTAINER_NAME \
  --network $NETWORK_NAME \
  $IMAGE_NAME

echo "End"

