from setuptools import setup, find_packages
import os

this_directory = os.path.abspath(os.path.dirname(__file__))
with open(os.path.join(this_directory, "README_pipy.md"), encoding="utf-8") as f:
    long_description = f.read()

setup(
    name="opencapif_sdk",
    version="0.1.22",
    author="Guillermo Sanz López. Miguel Ángel Adorna Ruiz",
    author_email="guillermo.sanzlopez@telefonica.com, miguelangel.adornaruiz@telefonica.com",
    description=(
        "This repository develops a Python Software Development Kit(SDK) which focuses on "
        "connecting to OpenCAPIF (Common API Framework for 3GPP Northbound APIs) in a simple way, "
        "lowering integration complexity and allowing developers to focus on Network Applications (Network Apps) or services development."
    ),
    long_description=long_description,
    long_description_content_type="text/markdown",
    license="LICENSE",
    python_requires=">=3.9",
    keywords=[
        "pesp_capif_sdk", "capif", "sdk capif", "opencapif_sdk"
    ],
    classifiers=[
        "Programming Language :: Python :: 3",
        "Operating System :: OS Independent",
    ],
    packages=find_packages(include=["opencapif_sdk", "opencapif_sdk.*"]),  # Ajusta según tus necesidades
    install_requires=[
        "Flask>=3.1.2,<4",
        "Werkzeug>=3.1.2,<4",
        "Jinja2>=3.1.4,<4",
        "MarkupSafe>=2.1.5,<4",
        "Flask-JWT-Extended>=4.6.0,<5",
        "requests>=2.32.3,<3",
        "urllib3>=2.2.2,<3",
        "certifi>=2024.7.4",
        "idna>=3.7,<4",
        "PyYAML>=6.0.1,<7",
        "cryptography>=43.0.1,<46",
        "pyOpenSSL>=25.1.0,<26",
        "python-dateutil>=2.9.0.post0,<3",
        "six>=1.16.0,<2",
        'typing-extensions>=4.12.0,<5; python_version<"3.11"',
        "connexion[flask]>=3.0.0,<4",
        "text-unidecode>=1.3,<2",
    ],
    extras_require={
        "dev": [
            "pytest>=8.3.2,<9",
            "coverage>=7.4.0,<8",
            "flake8>=7.1.0,<8",
            "jinja2-time==0.2.0",
            "binaryornot>=0.4.4,<0.5",
            "pycodestyle>=2.14,<2.15",
            "pyflakes>=3.4,<3.5",
            "mccabe>=0.7,<0.8",
        ],
    },
    url="https://labs.etsi.org/rep/ocf/sdk",
)
