#!/bin/bash

set -euo pipefail

SDK_DIR="/sdk"
SDK_REPO="https://labs.etsi.org/rep/ocf/sdk.git"
SDK_JUST_INSTALLED="true"

if [[ -d "$SDK_DIR/.git" ]]; then
    echo "OpenCAPIF SDK repository exists. Updating..."
    git -C "$SDK_DIR" pull
    SDK_JUST_INSTALLED="false"
else
    echo "OpenCAPIF SDK repository not found. Cloning..."
    git clone "$SDK_REPO" "$SDK_DIR"
fi

### !!!
# python -m build

echo "Installing OpenCAPIF SDK dependencies..."

python -m pip install -r "$SDK_DIR/installation/requirements.txt"
python -m pip install "$SDK_DIR"

[[ "$SDK_JUST_INSTALLED" == "true" ]] && action_text="installation completed" || action_text="updated"
echo "OpenCAPIF SDK $action_text successfully."

tail -f /dev/null  # TODO: Replace with actual entrypoint command (tests)
