from opencapif_sdk import capif_provider_connector
import json
import sys

capif_sdk_config_path = "./testing_CICD_capif_sdk_config_sample.json"

if __name__ == "__main__":
    try:
        # Initialize the connector
        capif_connector = capif_provider_connector(config_file=capif_sdk_config_path)
        
        capif_connector.onboard_provider()
        print("PROVIDER ONBOARDING COMPLETED")

        capif_connector.api_description_path = "./api_descriptor_testing.json"

        api6g = capif_connector.provider_capif_ids["APF-1"]
        api5g = capif_connector.provider_capif_ids["APF-2"]

        Peñuelas = capif_connector.provider_capif_ids["AEF-1"]
        Distrito = capif_connector.provider_capif_ids["AEF-2"]
        Valladolid = capif_connector.provider_capif_ids["AEF-3"]

        capif_connector.publish_req['publisher_apf_id'] = api6g

        capif_connector.publish_req['publisher_aefs_ids'] = [Peñuelas, Distrito]

        capif_connector.publish_services()

        print("API PUBLISHED")

    except FileNotFoundError as e:
        print(f"Error: {e}")
        sys.exit(1)
    except json.JSONDecodeError as e:
        print(f"Error reading the JSON file: {e}")
        sys.exit(1)
    except Exception as e:
        print(f"Unexpected error: {e}")
        sys.exit(1)
