import json
import time
import requests
from opencapif_sdk import capif_invoker_connector, service_discoverer
import logging


# Path to the OpenCAPIF SDK configuration file
capif_sdk_config_path = "./capif_sdk_config_sample.json"

import requests
import json
import sys

if __name__ == "__main__":
    logging.basicConfig(level=logging.INFO)

    try:
        # Onboard the Invoker (creates keys, registers, obtains certs)
        capif_connector = capif_invoker_connector(config_file=capif_sdk_config_path)
        capif_connector.onboard_invoker()
        print("✅ INVOKER ONBOARDING COMPLETED")

        # Discover APIs and obtain JWT token
        discoverer = service_discoverer(config_file=capif_sdk_config_path)
        discoverer.discover()
        discoverer.get_tokens()

        # Show the token
        print("✅ ACCESS TOKEN:")
        print(discoverer.token)

        # End
        print("🎉 Script finished successfully.")

    except FileNotFoundError as e:
        print(f"Error: {e}")
        sys.exit(1)
    except json.JSONDecodeError as e:
        print(f"Error reading the JSON file: {e}")
        sys.exit(1)
    except Exception as e:
        print(f"Unexpected error: {e}")
        sys.exit(1)
