# OpenCAPIF SDK full documentation

OpenCAPIF SDK implements this set of features to easily integrate an application with CAPIF NF either manually, using scripting, or integrating SDK library directly within app code.

Before using it, it is required to have fulfilled the [requirements](./sdk-prerequirements.md) section, the [installation](./sdk-installation.md) section and the selected parts of the [configuration](./sdk-configuration.md) depending on the CAPIF role the NetApp is going to play.

![GENERAL CAPIF USAGE FLOW](./images/Flujo%20completo-OPENCAPIF%20ACTUAL.jpg)

This repository includes 2 different modes to test OpenCAPIF SDK:

- **Development usage**: import SDK in the code and start ... Within [nf-sample folder](../netapp-samples/), it is provided a sample application leveraging

- **Manual usage**: use a set of python [scripts](../scripts/) to test step by step all implemented procedures. All of them are provided at scripts folder

    -  For Manual usage it is required to complete the utilities file with the absolute paths of target environment in order to complete the configuration of the SDK:

**NOTE**:register file is not needed for the use of the SDK

**IMPORTANT**:It is needed to fill out config files depending on the features required to be used from the SDK.Please if it is not fulfilled this file, go to the [Configuration Section](./sdk-configuration.md)

# Table of contents

As explained before, OpenCAPIF SDK is designed to play two different roles:

- [Provider NetApp](#provider-netapp)
    - [Important information for Providers](#important-information-for-providers)
    - [Onboard Provider](#provider-onboarding)
    - [Publish services](#services-publishing)
    - [Unpublish services](#services-deletion)
    - [Update services](#services-update)
    - [Get published services](#get-services)
    - [Get all published services](#get-all-services)
    - [Update and offboard Provider](#update-and-offboard-provider)
- [Invoker NetApp](#invoker-netapp)
    - [Important information for Invokers](#important-information-for-invokers)
    - [Onboard process](#onboarding-process)
    - [Discover process](#discover-process)
    - [Get JWT tokens](#obtain-invoker-tokens)
    - [Update and offboarding process](#update-and-offboard-invoker)
- [Other Features](#other-features)
    - [Register and Login](#script-register_and_loginpy)
    - [Deregister and Login](#script-deregister_and_loginpy)

# Provider NetApp

CAPIF SDK allows developers to quickly implement NetApp provider flow in just some code lines. This section contains the full guide of all available features in SDK related to CAPIF providers.

### Important information for Providers

Within the `provider_folder`, the SDK will store some folders named with the provided `capif_username` it has been previously registered from CAPIF administrator. At each folder, there will be found the following files:

- `capif_provider_details.json` : Contains all the APFs and AEFs ids that have already onboarded with this capif_username
- `CAPIF_<api_name><_API_id>.json` : If it's already published or updated an API, It will be available a copy of the last payload.
- `service_received.json` : If it's already used the get an api or get all apis functionality, It will be available the response to the request.
- `published-apis.json` : Contains the currently published APIs with their ApiId


### Provider onboarding

CAPIF SDK references:
* **CAPIF SDK function**: <mark>onboard_provider()</mark>
* **CAPIF SDK script**: <mark>provider_capif_connector.py</mark>

SDK simplifies the onboarding process for Provider developers. It also provides the capability to register several APFs and AEFs if necessary.

![Provider_onboard](./images/Flujo%20completo-provider_onboard.jpg)

[CAPIF_Publish_Service_API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Publish_Service_API.yaml) 

Using Publish Service it is required to fulfill certain fields of the [capif-sdk-config.json](./sdk-configuration.md) file.

### Services publishing

CAPIF SDK references:
* **CAPIF SDK function**: <mark>publish_services()</mark>
* **CAPIF SDK script**: <mark>provider_publish_api.py</mark>

SDK simplifies the process of publishing an API in CAPIF. Besides, it also provides the ability to chose which APF and AEFs will be used to publish the API.

It is mandatory to be [onboarded as a provider](#onboard_provider--script-provider_capif_connectorpy):

    Mandatory fields:
    - PublisherAPFid
    - PublisherAEFsids

### Services deletion

CAPIF SDK references:
* **CAPIF SDK function**: <mark>unpublish_service()</mark>
* **CAPIF SDK script**: <mark>provider_unpublish_api.py</mark>

SDK simplifies the process of deleting an API available in CAPIF.

It is mandatory to have onboarded as a [provider](#onboard_provider--script-provider_capif_connectorpy) before and to have [published any service](#publish_services--script-provider_publish_apipy) before 

    Mandatory fields:
    - ServiceApiId
    - PublisherAPFid
    - PublisherAEFsids

### Services update

CAPIF SDK references:
* **CAPIF SDK function**: <mark>update_service()</mark>
* **CAPIF SDK script**: <mark>provider_update_api.py</mark>

SDK simplifies the process of updating an API already registered at CAPIF. It also supports selecting which APF and AEFs will be used to update the API.

It is mandatory to have onboarded as a [provider](#onboard_provider--script-provider_capif_connectorpy) before and to have [published any service](#publish_services--script-provider_publish_apipy) before

    Mandatory fields:
    - ServiceApiId
    - PublisherAPFid
    - PublisherAEFsids

### Get services

CAPIF SDK references:
* **CAPIF SDK function**: <mark>get_service()</mark>
* **CAPIF SDK script**: <mark>provider_get_published_api.py</mark>

SDK simplifies the process of receiving the information of one service published previously in published-apis.json

It is mandatory to have onboarded as a [provider](#onboard_provider--script-provider_capif_connectorpy) before and to have [published any service](#publish_services--script-provider_publish_apipy) before

    Mandatory fields:
    - ServiceApiId
    - PublisherAPFid

### Get all services

CAPIF SDK references:
* **CAPIF SDK function**: <mark>get_all_services()</mark>
* **CAPIF SDK script**: <mark>provider_get_all_published_api.py</mark>

SDK simplifies the process of receiving the information of all available services published previously in published-apis.json

It is mandatory to have onboarded as a [provider](#onboard_provider--script-provider_capif_connectorpy) before and to have [published any service](#publish_services--script-provider_publish_apipy) before

    Mandatory fields:
    - PublisherAPFid

![Provider_publish](./images/Flujo%20completo-provider_publish_functions.jpg)

### Update and Offboard provider

CAPIF SDK references:
* **CAPIF SDK function**: <mark>update_provider()</mark> and <mark>offboard_provider()</mark>
* **CAPIF SDK script**: <mark>provider_capif_connector_update.py</mark> and <mark>provider_capif_connector_offboarding.py</mark>

For using this features we must be previously onboarded as a provider.

![Provider_update-offboard](./images/Flujo%20completo-provider_update_offboard.jpg)

# Invoker NetApp

CAPIF SDK allows developers to quickly implement NetApp invokers flow in just some code lines. This section contains the full guide of all available features in SDK related to CAPIF invokers.

### Important information for Invokers

Within the `invoker_folder`, the SDK will store some folders named with the provided `capif_username` it has been previously registered from CAPIF administrator. At each folder, there will be found the following files:

-   `capif_api_security_context_details.json`: This file contains the information of the invoker. It will contain:
        
    1. The `api_invoker_id`,
    2. If it has already used the Service Discovery Functionality, it will be found all the available APIs with their information,
    3. If it has already used the Service Get Token functionality, it will be found the access token for using the APIs that has already been discovered.

### Onboarding process

CAPIF SDK references:
* **CAPIF SDK function**: <mark>onboard_invoker()</mark>
* **CAPIF SDK script**: <mark>invoker_capif_connector.py</mark>

Simplifies the process of onboarding for Invoker users

![Invoker_onboard](./images/Flujo%20completo-invoker_onboard.jpg)

### Discover process

CAPIF SDK references:
* **CAPIF SDK function**: <mark>discover()</mark>
* **CAPIF SDK script**: <mark>invoker_service_discover.py</mark>

In this functionality, [discover_filter](./sdk-configuration.md) is used to retrieve the access of target API specified in discover filter.

It is mandatory to be onboarded as a [invoker](#onboard_invoker--script-invoker_capif_connectorpy).

DISCLAIMER: if it's the first time the user runs discover() it will appear a warning alert like this

      WARNING - Received 404 error, redirecting to register security service
    
![Invoker_discover](./images/Flujo%20completo-invoker_discover.jpg)

### Obtain Invoker tokens

CAPIF SDK references:
* **CAPIF SDK function**: <mark>get_tokens()</mark>
* **CAPIF SDK script**: <mark>invoker_service_get_token.py</mark>

This functionality simplifies the process of creating a security context based on JWT tokens in CAPIF, allowing to access the target APIs.

This functionality **requires** to to be onboarded as a [invoker](#onboard_invoker--script-invoker_capif_connectorpy) before and run the [discover](#discover--script-invoker_service_discoverpy) function at least once before.

![Invoker_get_token](./images/Flujo%20completo-invoker_get_tokens.jpg)

### Update and offboard invoker

CAPIF SDK references:
* **CAPIF SDK function**: <mark>update_invoker()</mark> & <mark>offboard_and_deregister_Invoker()</mark>
* **CAPIF SDK script**: <mark>invoker_capif_connector_update.py</mark> & <mark>invoker_capif_connector_offboarding.py</mark>

To use these features, the NetApp must be previously [onboarded as an invoker](#onboard_invoker--script-invoker_capif_connectorpy).

![Invoker_update-offboard](./images/Flujo%20completo-invoker_update_offboard.jpg)

# Other features

Apart from the OpenCAPIF SDK core features shown above, there are available different functionalities for SDK development purposes.

### CAPIF registration and login

CAPIF SDK reference:
* **CAPIF SDK script**: <mark>register_and_login.py</mark>

Eases the logging process for admin users and creates a CAPIF user,

### CAPIF deregistration and logout 

CAPIF SDK reference:
* **CAPIF SDK script**: <mark>deregister_and_login.py</mark>

Eases the logging process for admin users and removes a CAPIF user.

![Register picture](./images/Flujo%20completo-SDK%20ACTUAL%20CON%20REGISTER.jpg)







