# OpenCAPIF SDK full documentation

The OpenCAPIF SDK simplifies the integration of applications with the CAPIF NF, offering several features for both manual use and automated scripting, as well as direct integration into application code.

This documentation provides a step-by-step guide on how to use the SDK, explaining each functionality in detail. Before diving into the specifics, ensure the necessary prerequisites are met and learn about the available testing modes for the SDK.

## Getting Started

Before using the SDK, make sure the following steps have been completed:
- Fulfill the [requirements](../README.md) section,
- Follow the [installation instructions](./sdk_developers.md),
- Configure the SDK by completing the relevant parts of the [configuration](./sdk_configuration.md) section, based on the CAPIF role your NetApp will perform.

## Available SDK Usage Modes

![GENERAL CAPIF USAGE FLOW](./images/flows_opencapif_actual.jpg)

This repository provides 2 modes for using OpenCAPIF SDK:

1. **Development Mode**: Import the SDK into your code and start developing. Sample applications using the SDK are provided in the [network_app_samples](../netapp-samples/) folder.

2. **Manual Mode**: Use a set of Python [scripts](../scripts/) to test each step of the integration process manually. For manual usage, it is essential to complete the utilities file with absolute paths of the target environment to finalize SDK configuration.

**IMPORTANT**: all SDK configuration files must be filled out depending on the role and features planned to be used. For further details, refer to the [Configuration Section](./sdk_configuration.md).

**NOTE**: register file is not required for SDK usage, just for SDK developers.

## Table of Contents

As outlined in the [Network App developers section](../README.md), OpenCAPIF SDK supports two primary roles:

- [Provider NetApp](#provider-netapp)
    - [Important Information for Providers](#important-information-for-providers)
    - [Provider Onboarding](#provider-onboarding)
    - [Service Publishing](#services-publishing)
    - [Service Deletion](#services-deletion)
    - [Service Updates](#services-update)
    - [Get Published Services](#get-services)
    - [Get All Published Services](#get-all-services)
    - [Update and Offboard Provider](#update-and-offboard-provider)
- [Invoker NetApp](#invoker-netapp)
    - [Important Information for Invokers](#important-information-for-invokers)
    - [Invoker Onboarding](#invoker-onboarding)
    - [Service Discovery](#discover-process)
    - [Obtain JWT Tokens](#obtain-invoker-tokens)
    - [Update and Offboard Invoker](#update-and-offboard-invoker)
- [Other Features](#other-features)
    - [CAPIF Registration and Login](#capif-registration-and-login)
    - [CAPIF Deregistration and Logout](#capif-registration-and-login)

## Provider NetApp

The OpenCAPIF SDK allows developers to quickly implement the provider flow for NetApp using just a few lines of code. This section provides a comprehensive guide to the SDK features related to CAPIF providers.

### Important Information for Providers

Inside the `provider_folder`, the SDK stores directories named after the registered `capif_username`. Each folder contains:

- `capif_provider_details.json`: Contains all APFs and AEFs IDs that have been onboarded with the associated username.
- `capif_<api_name>_<api_id>.json`: Stores a copy of the last payload for any published or updated API.
- `service_received.json`: Stores responses for the Get API or Get All APIs functionality.
- `published-apis.json`: Contains a list of currently published APIs with their respective IDs.

All configuration values are available within the `capif_provider_connector` object. Additionally, the `api_prov_funcs` variable is a dictionary where APFs and AEFs are the keys, and their respective IDs are the values.

### Provider Onboarding

OpenCAPIF SDK references:
- **Function**: `onboard_provider()`
- **Script**: `provider_capif_connector.py`

The SDK streamlines the onboarding process for providers, allowing them to register multiple APFs and AEFs as needed.

![Provider_onboard](./images/flows_provider_onboard.jpg)

### Service Publishing

OpenCAPIF SDK references:
- **Function**: `publish_services()`
- **Script**: `provider_publish_api.py`

The SDK simplifies the process of publishing an API in CAPIF, with the option to select specific APFs and AEFs. Before publishing, ensure you’ve [onboarded as a provider](#provider-onboarding).

**Required SDK inputs**:
- PublisherAPFid
- PublisherAEFsids

### Service Deletion

OpenCAPIF SDK references:
- **Function**: `unpublish_service()`
- **Script**: `provider_unpublish_api.py`

The SDK simplifies API deletion in CAPIF. To delete a service, you must be [onboarded as a provider](#provider-onboarding) and have [published a service](#services-publishing) beforehand.

**Required SDK inputs**:
- ServiceApiId
- PublisherAPFid
- PublisherAEFsids

### Service Updates

OpenCAPIF SDK references:
- **Function**: `update_service()`
- **Script**: `provider_update_api.py`

The SDK facilitates updating a previously registered API and allows selecting the APFs and AEFs used for the update. Ensure you’ve [onboarded as a provider](#provider-onboarding) and have [published a service](#services-publishing) beforehand.

**Required SDK inputs**:
- ServiceApiId
- PublisherAPFid
- PublisherAEFsids

### Get Services

OpenCAPIF SDK references:
- **Function**: `get_service()`
- **Script**: `provider_get_published_api.py`

Retrieve information about a previously published service in `service_received.json`. Before retrieving services, you must be [onboarded as a provider](#provider-onboarding) and have [published a service](#services-publishing).

**Required SDK inputs**:
- ServiceApiId
- PublisherAPFid

### Get All Services

OpenCAPIF SDK references:
- **Function**: `get_all_services()`
- **Script**: `provider_get_all_published_api.py`

Retrieve information about all previously published services in `service_received.json`. Ensure you are [onboarded as a provider](#provider-onboarding) and have [published services](#services-publishing).

**Mandatory Field**:
- PublisherAPFid

![Provider_publish](./images/flows_provider_publish_functions.jpg)

### Update and Offboard Provider

OpenCAPIF SDK references:
- **Functions**: `update_provider()` and `offboard_provider()`
- **Scripts**: `provider_capif_connector_update.py` and `provider_capif_connector_offboarding.py`

You must be onboarded as a provider before using these features.

![Provider_update-offboard](./images/flows_provider_update_offboard.jpg)

## Invoker NetApp

The OpenCAPIF SDK enables developers to implement invoker functionality for NetApp efficiently. This section provides a complete guide to SDK features related to CAPIF invokers.

### Important Information for Invokers

Inside the `invoker_folder`, the SDK stores directories named after the registered `capif_username`. Each folder contains:

- `capif_api_security_context_details.json`: Stores details about the invoker, including:
    1. `api_invoker_id`
    2. Discovered APIs and their information (if Service Discovery has been used)
    3. JWT access tokens for discovered APIs (if Service Get Token functionality has been used)

### Invoker Onboarding

OpenCAPIF SDK references:
- **Function**: `onboard_invoker()`
- **Script**: `invoker_capif_connector.py`

The SDK simplifies the invoker onboarding process.

![Invoker_onboard](./images/flows_invoker_onboard.jpg)

### Service Discovery

OpenCAPIF SDK references:
- **Function**: `discover()`
- **Script**: `invoker_service_discover.py`

Use the [discover_filter](./sdk_configuration.md) to retrieve access to target APIs. Ensure you are [onboarded as an invoker](#invoker-onboarding) before using this feature.

**Note**: If this is the first time running `discover()`, you may receive a 404 warning, prompting registration for the security service.

![Invoker_discover](./images/flows_invoker_discover.jpg)

### Obtain JWT Tokens

OpenCAPIF SDK references:
- **Function**: `get_tokens()`
- **Script**: `invoker_service_get_token.py`

The SDK streamlines the creation of a security context using JWT tokens, which allows access to target APIs. Ensure you are [onboarded as an invoker](#invoker-onboarding) and have used the [discover](#discover-process) function beforehand.

![Invoker_get_token](./images/flows_invoker_get_tokens.jpg)

### Update and Offboard Invoker

OpenCAPIF SDK references:
- **Functions**: `update_invoker()` & `offboard_and_deregister_invoker()`
- **Scripts**: `invoker_capif_connector_update.py` & `invoker_capif_connector_offboarding.py`

Ensure you are [onboarded as an invoker](#invoker-onboarding) before using these features.

![Invoker_update-offboard](./images/flows_invoker_update_offboard.jpg)

## Other Features

OpenCAPIF SDK reference:
* **OpenCAPIF SDK script**: <mark>register_and_login.py</mark>

Eases the logging process for admin users and creates a CAPIF user,

### CAPIF deregistration and logout 

OpenCAPIF SDK reference:
* **OpenCAPIF SDK script**: <mark>deregister_and_login.py</mark>

Eases the logging process for admin users and removes a CAPIF user.

![Register picture](./images/flows_sdk_with_register.jpg)
