

# OpenCAPIF SDK

![OpenCAPIF icon](./doc/images/OpenCAPIF-icon.jpg)

This repository develops a Python Software Development Kit(SDK) which focuses on connecting to OpenCAPIF in a simple way, lowering integration complexity and allowing developers to focus on Network Applications (NetApps) or services development. 

OpentCAPIF SDK provides a set of libraries to enable either CAPIF provider and invoker roles, and other functions to simplify procedures calls towards OpenCAPIF entity.

Current version of OpenCAPIF SDK is compatible with following publicly available releases:
- [OpenCAPIF Release 1.0](https://ocf.etsi.org/documentation/v1.0.0-release/)

# Table of Contents
 1. [OpenCAPIF SDK summary](#opencapif-sdk-summary)
 2. [NetApp developer path](#netapp-developer-path)
 3. [OpenCAPIF SDK Prerequeriments](./doc/sdk-prerequirements.md)
 4. [OpenCAPIF SDK Installation](./doc/sdk-installation.md)
 5. [OpenCAPIF SDK Configuration](./doc/sdk-configuration.md)
 6. [OpenCAPIF SDK Usage](./doc/sdk-usage.md)
 7. [OpenCAPIF SDK known issues](./doc/sdk-issues.md)


# OpenCAPIF SDK summary

OpenCAPIF SDK brings a set of functions to integrate with the 5G Core's function CAPIF, as defined in [3GPP Technical Specification (TS) 29.222 V18.5.0 Common API Framework for 3GPP Northbound APIs](https://www.etsi.org/deliver/etsi_ts/129200_129299/129222/18.05.00_60/ts_129222v180500p.pdf). This section shows the mapping between the Python functions available in this SDK and the CAPIF OpenAPI APIs defined the reference standard:

| **CAPIF API**                                   | **OpenCAPIF SDK function**                                  | **Description**                                             |
|-------------------------------------------------|-------------------------------------------------------------|-------------------------------------------------------------|
| onboardedInvokers (POST)                        | onboard_invoker()                                           | Registers a new invoker.                                    |
| onboardedInvokers (PUT)                         | update_invoker()                                            | Updates an existing invoker.                                |
| onboardedInvokers (DELETE)                      | offboard_invoker()                                          | Deletes an invoker.                                         |
| registrations (POST)                            | onboard_provider()                                          | Registers a new service provider.                           |
| registrations (PUT)                             | update_provider()                                           | Updates a service provider's registration.                  |
| registrations (DELETE)                          | offboard_provider()                                         | Deletes a service provider's registration.                  |
| allServiceAPIs (GET)                            | discover()                                                  | Retrieves a list of all available service APIs.             |
| trustedInvokers (PUT//POST)                     | discover()                                                  | Registers or updates trusted invokers.                      |
| securities/{securityId}/token (GET)             | get_tokens()                                                | Retrieves a security token for a specific `securityId`.     |
| service-apis (POST)                             | publish_services()                                          | Registers a new service API into the system.                |
| service-apis (DELETE)                           | unpublish_service()                                         | Deletes a service API from the system.                      |
| service-apis (PUT)                              | update_service()                                            | Updates the details of an existing service API.             |
| service-apis (GET)                              | get_service()                                               | Retrieves the details of a specific service API.            |
| service-apis (GET)                              | get_all_services()                                          | Retrieves a list of all available service APIs.             |


NOTE: Above mentioned CAPIF APIs are defined in these 3GPP references:
- [CAPIF Invoker API specification](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_API_Invoker_Management_API.yaml)
- [CAPIF Provider API specification](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_API_Provider_Management_API.yaml)
- [CAPIF Discover API specification](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Discover_Service_API.yaml)
- [CAPIF Publish API specification](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Publish_Service_API.yaml) 
- [CAPIF Security API specification](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Security_API.yaml)
# NetApp developer path

NetApp typical flow showcasing SDK usage.

## As an invoker
 
For performing this path it is necesary to: 

1. Create an invoker object  -> CAPIFInvokerConnector(config_file=utilities.get_config_file())

2. Run onboard_invoker()

3. Create a service discover object -> ServiceDiscoverer(config_file=utilities.get_config_file())

3. Run discover() 

4. Run get_tokens()

![INVOKER_PATH](./doc/images/Flujo%20completo-INVOKER%20PATH.jpg)

## As a provider 

For performing this path it is necesary to:

1. Create a provider object -> CAPIFProviderConnector(config_file=utilities.get_config_file())

2. Run onboard_provider()

3. Look for the provider api details on the username folder, choose the APF and AEFs identificators and fullfill the publish_req structure and the api_description_path

<p align="center">
  <img src="./doc/images/capif-provider-details-example.png" alt="example" width="400"/>
  <img src="./doc/images/publish_req-example.png" alt="config-example"  width="400"/>
</p>

3. Run publish_services()

![PROVIDER_PATH](./doc/images/Flujo%20completo-PROVIDER%20PATH.jpg)