# OpenCAPIF SDK usage

OpenCAPIF SDK implements this set of features to easily integrate an application with CAPIF NF either manually or integrating SDK library directly within app code.

[GENERAL CAPIF USAGE FLOW](./images/Flujo%20completo-OPENCAPIF%20ACTUAL.jpg)

This repository includes 2 different modes to test OpenCAPIF SDK:
- **Manual usage**: use a set of python scripts to test step by step all implemented procedures. All of them are provided at scripts folder,


- **Development usage**: import SDK in your code and start ... Within nf-sample folder, it is provided a sample application leveraging

# As an invoker

The common path to follow using CAPIF in order to get an API token of the service it's wanted to use is by following this steps:

- register_and_onboard_Invoker() // Script invoker_capif_connector.py  

![Invoker_onboard](./images/Invoker_onboarding.png)

- discover() // Script invoker_service_discover.py
In this functionality it could be used [Discover_filter.json](./sdk-configuration.md) to retrieve only the access of the API's it's wanted to access

![Invoker_discover](./images/Invoker_discover.png)

- get_tokens() // Script invoker_service_get_token.py

![Invoker_get_token](./images/invoker_get_token.png)

# As an provider
The common path to follow using CAPIF in order to publish an API is by following this steps:

- register_and_onboard_provider() // Script provider_capif_connector.py

![Provider_onboard](./images/provider_onboarding.png)

[CAPIF_Publish_Service_API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Publish_Service_API.yaml) 

For using the Publish Service is mandatory to fullfill certain fields of the [Publish.json](./sdk-configuration.md) file

- publish_services(service_api_description_json_full_path) // Script provider_publish_api.py

    Mandatory fields:
    - PublisherAPFid
    - PublisherAEFsids

- unpublish_service(service_api_description_json_full_path) // Script provider_unpublish_api.py

    Mandatory fields:
    - ServiceApiId
    - PublisherAPFid
    - PublisherAEFsids

- update_service(service_api_description_json_full_path) // Script provider_update_api.py

    Mandatory fields:
    - ServiceApiId
    - PublisherAPFid
    - PublisherAEFsids

- get_service() // Script provider_get_published_api.py

    Mandatory fields:
    - ServiceApiId
    - PublisherAPFid

- get_all_services() // Script provider_get_all_published_api.py

    Mandatory fields:
    - PublisherAPFid

![Provider_publish](./images/provider_publish.png)

# OpenCAPIF SDK scripts

This repository provides manual scripts to validate and demonstrate the integration to OpenCAPIF. Next are listed the behaviour of all of them available at /sctipts folder:
1. 
2. 
3. 
4. 

Additional requests to CAPIF:
- Publisher: addionally a devoloper could retrieve data from ...
    1. 
    2. 

- Events: blah blah

- Explore API directory:


- **Invoker CAPIF connector**: Simplifies the process of onboarding for Invoker users,
- **Provider CAPIF connector**: Simplifies the process of onboarding for Provider users,also has the capability to register several APF's and AEF's if its necesary,
- **Invoker Service Discovery**: Facilitates making a Discovery request to CAPIF, also stores the API services recieved and has an option to filter them,
- **Invoker Service Get token**: After the Discovery, this functionality simplifies the way of getting created their propperly security context for each of the services and adquiring the access token to use the final APIs, 
- **Provider Publish API**: Simplifies the process of publishing an API. Also has the capability to chose which APF and AEF's will be used to publish the API,
- **Provider Unpublish API**: Simplifies the process of deleting an API,
- **Provider Update API**: Simplifies the process of updating an API. Also has the capability to chose which APF and AEF's will be used to update the API,
- **Provider Get API**: Simplifies the process of recieving the information of One service published previously,
- **Provider Get all APIs**: Simplifies the process of recieving the information of all available services published previously,
- **Invoker CAPIF connector offboarding**: Simplifies the process of offboarding for Invoker users,
- **Provider CAPIF connector offboarding**: Simplifies the process of offboarding for Provider users.

[OPENCAPIF SDK CODE STRUCTURE]

![Descripción de la imagen](./doc/images/Flujo%20completo-OPENCAPIF%20ACTUAL.jpg)


## Other features

Apart from the SDK core, there are available different functionalities for development purposes:

- **Register and login**: Facilitates the logging process for admin users and creates a CAPIF user, 
- **Deregister and login**: Facilitates the logging process for admin users and eliminates a CAPIF user.

![Descripción de la imagen](./doc/images/Flujo%20completo-SDK%20ACTUAL%20CON%20REGISTER.jpg)


# How to use OpenCAPIF SDK

1 - First it is required to complete the utilities file with the absolute paths of target environment in order to complete the configuration of the SDK:
- NOTE register file is not needed for the use of the SDK,
- NOTE provider_exposer_get_sample_api_description_path is mandatory if publish functionalities are required.

2 - Then it is needed to fill out config files depending on the features required to be used from the SDK.


