import sys
import os
import json

# Add the SDK directory to PYTHONPATH using a relative path
script_dir = os.path.dirname(os.path.abspath(__file__))  # Current script directory
sdk_path = os.path.join(script_dir, '..', '..', 'sdk')  # Go up two levels and point to 'sdk'
sys.path.insert(0, sdk_path)
from sdk import CAPIFProviderConnector

capif_sdk_config_path = "./capif-sdk-config-sample.json"

if __name__ == "__main__":
    try:
        # Initialize the connector
        capif_connector = CAPIFProviderConnector(config_file=capif_sdk_config_path)
        capif_connector.onboard_provider()
        print("PROVIDER ONBOARDING COMPLETED")

        provider_folder = capif_connector.provider_folder

        detailspath = os.path.join(provider_folder, "capif_provider_details.json")

        with open(detailspath, 'r') as file:
            details = json.load(file)

        APF = details.get('APF-1_api_prov_func_id')
        AEF1 = details.get('AEF-1_api_prov_func_id')
        AEF2 = details.get('AEF-2_api_prov_func_id')
        AEF3 = details.get('AEF-3_api_prov_func_id')

        capif_connector.publish_req['publisher_apf_id'] = APF
        capif_connector.publish_req['publisher_aefs_ids'] = [AEF1, AEF2]

        capif_connector.publish_services()

        capif_connector.api_description_path = "./nef-upf-partner-2.json"

        capif_connector.publish_req['publisher_aefs_ids'] = [AEF1, AEF2, AEF3]

        capif_connector.publish_services()

    except FileNotFoundError as e:
        print(f"Error: {e}")
    except json.JSONDecodeError as e:
        print(f"Error reading the JSON file: {e}")
    except Exception as e:
        print(f"Unexpected error: {e}")