## OpenCAPIF SDK configuration

Before configuration it's needed to have completed the [prerequirements](./sdk-prerequirements.md) section and the [installation](./sdk-installation.md) section.

IMPORTANT: All jsons configuration files **MUST** be in the same folder
### **1. Configuration via Config.json**

This file could also be fullfilled by [enviroment variables](../samples/enviroment-variables-sample.txt)

- invoker_folder: The path (relative or absolute) of the folder you want to store your invoker information

- provider_folder:The path (relative or absolute) of the folder you want to store your provider information

- capif_host:The domain name of your capif host

- register_host:The domain name of your register host

- capif_https_port: The port of your capif host 

- capif_register_port:The port of your register host

- capif_callback_url:The Url you want to recieve CAPIF notifications(This functionality is not currently available) 

- csr fields: Seven information fields for generating your invoker certificate 

- capif_username: CAPIF username 

- capif_password: CAPIF password 

- APFs: Number of APF's you want to onboard as a provider Example:5 

- AEFs: Number of AEF's you want to onboard as a provider Example:2

- debug_mode: Boolean | If you want to recieve logs from SDK Example:True/False


Mandatory fields no matter the target role to be onboarded, either invoker or provider:

- capif_host
- register_host
- capif_https_port
- capif_register_port
- capif_username
- capif_password
- debug_mode

If you want to use SDK as an **Invoker** you need to fill out these fields

- invoker_folder
- capif_callback_url
- csr_information(csr_common_name,csr_country_name...)

If you want to use SDK as a **Provider** you need to fill out these fields

- provider_folder
- APFs
- AEFs
     
### **2. Configuration of Publish.json**

This configuration file is only mandatory if we want to use the [CAPIF_Publish_Service_API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Publish_Service_API.yaml) 

   - serviceApiId: The Api id we want to use Example "02eff6e1b3a8f7c8044a92ee8a30bd"
   - publisherAPFid: APF id we chose to use Example : "APFa165364a379035d14311deadc04332"
   - publisherAEFsids: Array of strings filled out of AEFs ids we want to use Example:        ["AEFfa38f0e855bffb420e4994ecbc8fb9","AEFe8bfa711f4f0c95ba0b382508e6382"]

For using the Publish Api function or the Update function the provider_api_description_sample.json **must** have been  modified with the Publish API that is wanted to share following the standard schema for [ServiceAPIDescription](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Publish_Service_API.yaml)

**AefIds fields won't need to fill out the  from aefProfiles** array because you would already be configurating this fields by completing publisherAEFsids parameter

**If the publisherAEFsids parameter don't match with the aefProfiles in your [Api description](../api-samples/provider_api_description_sample.json) you will recieve an error**



#### **Configuration of Discover_filter.json**
This file follows the parameters schema from the GET petition of  [Discover Services API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Discover_Service_API.yaml) 

To use this feature it has to be completed `Discover_filter.json` with the parameters you want to be filtered in order to run the Invoker Service Discovery Functionality.

To run the Invoker Service Discovery Functionality it has to be onboarded as an Invoker before the CAPIF user.


#### **Configuration of Register.json**

In order to use this SDK in a Local enviroment and creating and removing users, its mandatory to fullfill this fields.

This Feature is not included in the SDK.

- register_host:The domain name of your register host
- capif_register_port: The port of your register host
- capif_register_username: CAPIF admin username
- capif_register_password: CAPIF admin password
- capif_username: CAPIF user username
- capif_password: CAPIF user password
- config_path: Absolute path to the Config_files folder
- uuid: UUID for Deregistering the user


This file is only used for the Functionalities of :
- Register and login 
- Deregister and login

Each field is obligatory to complete except UUID, which is only obligatory in case of Deregistering the user.

Although this field is not obligatory we recomend to store the UUID parameter recieved by the Register and login functionality in this field.    
