import utilities
from opencapif_sdk import capif_invoker_connector, capif_invoker_event_feature


def showcase_capif_connector():
    """
        This method showcases how one can use the CAPIFConnector class.
    """

    capif_connector = capif_invoker_connector(config_file=utilities.get_config_file())

    capif_connector.onboard_invoker()
    
    events = capif_invoker_event_feature(config_file=utilities.get_config_file())
    
    events.create_subscription(name="Servicio_2")
    
    events.update_subcription(name="Servicio_2")
    
    events.delete_subscription(name="Servicio_2")
    print("COMPLETED")


if __name__ == "__main__":
    # Register invoker to CAPIF. This should happen exactly once
    showcase_capif_connector()
