import sys
import os
import utilities

# Add the SDK directory to PYTHONPATH using a relative path
script_dir = os.path.dirname(os.path.abspath(__file__))  # Current script directory
sdk_path = os.path.join(script_dir, '..', 'sdk')  # Go up one level and point to 'sdk'
sys.path.insert(0, sdk_path)
from sdk import capif_invoker_connector

def showcase_capif_connector():
    """
        This method showcases how one can use the CAPIFConnector class.
        This class is intended for use within the evolved5G Command Line interface.
        It is a low level class part of the SDK that is not required to use while creating invokers
    """

    capif_connector = capif_invoker_connector(config_file=utilities.get_config_file())

    capif_connector.update_invoker()
    print("COMPLETED")


if __name__ == "__main__":
    # Register invoker to CAPIF. This should happen exactly once
    showcase_capif_connector()
