

# OpenCAPIF SDK

![OpenCAPIF icon](./doc/images/OpenCAPIF-icon.jpg)

This repository develops a Python Software Development Kit(SDK) which focuses on connecting to OpenCAPIF in a simple way, lowering integration complexity and allowing developers to focus on Network Applications (NetApps) or services development. 

OpentCAPIF SDK provides a set of libraries to enable either CAPIF provider and invoker roles, and other functions to simplify procedures calls towards OpenCAPIF entity.

Current version of OpenCAPIF SDK is compatible with following publicly available releases:
- [OpenCAPIF Release 1.0](https://ocf.etsi.org/documentation/v1.0.0-release/)


# OpenCAPIF SDK Features

This section shows the features available for using CAPIF SDK and its functions in order to import the sdk into another program. 

- [CAPIF_API_Invoker_management API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_API_Invoker_Management_API.yaml)

    - Onboard_API_Invoker: Corresponds to register_and_onboard_Invoker() 

    - Update_API_Invoker: Corresponds to update_Invoker()

    - Offboard_API_Invoker Corresponds to offboard_and_deregister_Invoker()

- [CAPIF_API_Provider_Management_API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_API_Provider_Management_API.yaml)

    - Onboard_API_Provider: Corresponds to register_and_onboard_provider()

    - Update_API_Provider: Corresponds to update_service()

    - Offboard_API_Provider: Corresponds to offboard_and_deregister_nef()

- [CAPIF_Discover_Service_API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Discover_Service_API.yaml)

    - Discover_Service_API: Corresponds to discover()

- [CAPIF_Publish_Service_API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Publish_Service_API.yaml)

    - Publish_Service_API: Corresponds to publish_services(service_api_description_json_full_path)

    - Unpublish_Service_API: Corresponds to unpublish_service(service_api_description_json_full_path)

    - Update_Service_API: Corresponds to update_service(service_api_description_json_full_path)

    - Get_Service_API: Corresponds to get_service()

    - Get_All_Service_API: Corresponds to get_all_services()

- [CAPIF_Security API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Security_API.yaml)
    
    - Obtain_Authorization: Corresponds to discover()

    

# Table of Contents
 1. [OpenCAPIF SDK Prerequeriments](./doc/sdk-prerequirements.md)
 2. [OpenCAPIF SDK Installation](./doc/sdk-installation.md)
 3. [OpenCAPIF SDK Configuration](./doc/sdk-configuration.md)
 4. [OpenCAPIF SDK Usage](./doc/sdk-usage.md)
 5. [OpenCAPIF SDK known issues](./doc/sdk-issues.md)


