
import sys
import os
import utilities

# Añadir el directorio del SDK al PYTHONPATH usando una ruta relativa
script_dir = os.path.dirname(os.path.abspath(__file__))  # Directorio actual del script
sdk_path = os.path.join(script_dir, '..', 'sdk')  # Subir un nivel y apuntar a 'sdk'
sys.path.insert(0, sdk_path)
from sdk import CAPIFProviderConnector
# Ahora importa las clases desde tu archivo sdk.py


def showcase_capif_nef_connector():
    """

    """
    capif_connector = CAPIFProviderConnector(config_file=utilities.get_config_file())

    capif_connector.unpublish_service()
    print("COMPLETED")


if __name__ == "__main__":
    # Let's register a NEF to CAPIF. This should happen exactly once
    showcase_capif_nef_connector()
