import sys
import os

# Add the SDK directory to PYTHONPATH using a relative path
script_dir = os.path.dirname(os.path.abspath(__file__))  # Current script directory
sdk_path = os.path.join(script_dir, '..', '..', 'sdk')  # Go up two levels and point to 'sdk'
sys.path.insert(0, sdk_path)
from sdk import CAPIFInvokerConnector, ServiceDiscoverer
capif_sdk_config_path = "/Users/dgs/Downloads/capif_sdk/invoker/config.json"
capif_sdk_config_path = "/Users/IDB0128/git_repos/pesp_capif_sdk/netapp-samples/netapp-invoker-sample/capif-sdk-config-sample.json"

if __name__ == "__main__":

    capif_connector = CAPIFInvokerConnector(config_file=capif_sdk_config_path)

    capif_connector.onboard_invoker()
    print("INVOKER ONBOARDING COMPLETED")

    # Now I have certificates, I can proceed with discovery (get token for an API or several, depending on your choice)

    # As a developer, I already know which APIs I want to access
    # DISCOVER filter configureCmcAmfSet
    # Without DISCOVER filter, the entire list of available APIs in CAPIF is obtained

    discoverer = ServiceDiscoverer(config_file=capif_sdk_config_path)

    discoverer.discover()

    discoverer.get_tokens()
