# OpenCAPIF SDK Configuration

Before starting the configuration process, it is required that both the [requirements](../README.md) and the [installation](./sdk_developers.md) sections are completed.

## Table of Contents
- [Configuration via capif_sdk_config.json](#configuration-via-capif_sdk_configjson)
  - [As a Network App Invoker](#network-app-invoker)
  - [As a Network App Provider](#network-app-provider)
  - [Descriptions of capif_sdk_config Fields](#descriptions-of-capif_sdk_config-fields)
- [Configuration via capif_sdk_register.json](#configuration-via-capif-sdk-registerjson)

## Configuration via `capif_sdk_config.json`

A sample configuration file can be found [here](../samples/config_sample.json).

### Common Fields for Invoker and Provider

Regardless of the role (Invoker or Provider), the following fields are mandatory:

- `capif_host`
- `register_host`
- `capif_https_port`
- `capif_register_port`
- `capif_username`
- `capif_password`
- `debug_mode`

### Network App Invoker

When configuring the SDK as a **Network App Invoker**, the following fields must be provided:

- `invoker_folder`
- `capif_callback_url`
- `supported_features`
- `cert_generation` (fields such as `csr_common_name`, `csr_country_name`, etc.)

**Optional:**
- `discover_filter`: useful to enable the discovery of specific APIs. Some fields under [`discover_filter`](#configuration-of-discover_filter) structure required to be configured when using discovery filters. Check devoted section below,
- `check_authentication_data`: useful to use `check_authentication()` function to validate features from a target provider, it will be required to fill up the `ip` and `port` parameters within the `check_authentication_data` variable.

### Network App Provider

For SDK configuration as a **Network App Provider**, the following fields are required:

- `provider_folder`
- `supported_features`
- `cert_generation` (fields such as `csr_common_name`, `csr_country_name`, etc.)
- `APFs`
- `AEFs`
- [`publish_req`](#configuration-of-publish_req)
- `api_description_path`

## Configuration of `discover_filter`

The `discover_filter` section adheres to the parameters defined in the GET request schema of the [Discover Services API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Discover_Service_API.yaml).

To use the service discovery functionality, the `discover_filter` fields should be populated with the desired filters. **It is important to note that fields such as `api-name` must contain only one entry of each type (i.e., no lists are allowed in api-name).**

For instance if the invoker fill the `api-name` field, the `discover()` functionality will retrieve only one API, the one that matches the exact name of the `api-name`.

Before running the Invoker Service Discovery Functionality, the Invoker must be onboarded to CAPIF.

## Configuration of `publish_req`

This section is mandatory when using the [CAPIF Publish Service API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Publish_Service_API.yaml). The following fields are required:

- `service_api_id`: Example: `"02eff6e1b3a8f7c8044a92ee8a30bd"`
- `publisher_apf_id`: Example: `"APFa165364a379035d14311deadc04332"`
- `publisher_aefs_ids`: An array of selected AEF IDs. Example: `["AEFfa38f0e855bffb420e4994ecbc8fb9", "AEFe8bfa711f4f0c95ba0b382508e6382"]`

The `api_description_path` must point to the Publish API to be shared, and it should follow the [ServiceAPIDescription](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Publish_Service_API.yaml) schema.

To obtain this schema, opencapif_sdk has a facility to translate Openapi structures to ServiceAPIDescription schemas.
More information:[Translator functionality](./sdk_full_documentation.md#openapi-translation)

If the `publisher_aefs_ids` do not match the `aefProfiles` in the API description, an error will be raised by the SDK.

## Descriptions of `capif_sdk_config` Fields

This file can also be populated using [environment variables](../samples/enviroment_variables_sample.txt).

- `invoker_folder`: The path (relative or absolute) where invoker information (certificates, keys, etc.) is stored.
- `provider_folder`: The path (relative or absolute) where provider information is stored.
- `supported_features`: A string used to indicate the features supported by an API. The string shall contain a bitmask indicating supported features in hexadecimal representation Each character in the string shall take a value of "0" to "9", "a" to "f" or "A" to "F". [More information](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29571_CommonData.yaml)
- `capif_host`: The domain name of the CAPIF host.
- `register_host`: The domain name of the register host.
- `capif_https_port`: The CAPIF host port number.
- `capif_register_port`: The register host port number.
- `capif_callback_url`: The URL used by CAPIF to send invoker notifications ([currently unavailable](sdk-issues.md)).
- `cert_generation`: Fields for certificate generation, with `csr_country_name` requiring a two-letter country code.
- `capif_username`: The CAPIF username.
- `capif_password`: The CAPIF password.
- `apfs`: The number of APFs to be onboarded as a provider (e.g., `5`).
- `aefs`: The number of AEFs to be onboarded as a provider (e.g., `2`).
- `debug_mode`: A boolean value to enable or disable SDK logs (e.g., `True` or `False`).
- [`discover_filter`](#configuration-of-discover_filter): Fields for configuring invoker service discovery.
- [`publish_req`](#configuration-of-publish_req): Fields required for API publishing.
- `api_description_path`: The path to the [ServiceAPIDescription](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Publish_Service_API.yaml) JSON file.
- `check_authentication_data`: The `ip` and `port` of the target Provider's AEF to get their supported features from.


## Configuration via `capif_sdk_register.json`

To use this SDK in a local environment for creating and removing users, the following fields must be populated. Note that this feature is not included in the SDK, but instructions can be found in the [CAPIF official repository](https://labs.etsi.org/rep/ocf/capif/-/tree/REL1?ref_type=heads).

- `register_host`: The domain name of the register host.
- `capif_register_port`: The port number of the register host.
- `capif_register_username`: The CAPIF admin username.
- `capif_register_password`: The CAPIF admin password.
- `capif_username`: The CAPIF user username.
- `capif_password`: The CAPIF user password.
- `config_path`: The absolute path to the configuration files folder.
- `uuid`: The UUID required for de-registering a user (only mandatory for de-registration).

This file is used for the following functionalities:
- Register and login.
- Deregister and login.

All fields are required except for `uuid`, which is only mandatory for de-registration. It is recommended to store the `uuid` returned from the registration process for future use.
