import sys
import os
import utilities

# Add the SDK directory to PYTHONPATH using a relative path
script_dir = os.path.dirname(os.path.abspath(__file__))  # Current script directory
sdk_path = os.path.join(script_dir, '..', 'sdk')  # Go up one level and point to 'sdk'
sys.path.insert(0, sdk_path)

# Now import the classes from your sdk.py file

from sdk import service_discoverer
def showcase_access_token_retrieval_from_capif():
    service_discoverer = service_discoverer(config_file=utilities.get_config_file())
    service_discoverer.get_tokens()


if __name__ == "__main__":
    # The following code assumes that you have already registered the net app to CAPIF.
    # showcase_service_discovery()
    # showcase_retrieve_endpoint_url_from_tsn()
    showcase_access_token_retrieval_from_capif()
    print("COMPLETED")
