# OpenCAPIF SDK usage

OpenCAPIF SDK implements this set of features to easily integrate an application with CAPIF NF either manually or integrating SDK library directly within app code.

Before usage it's needed to have completed the [prerequirements](./sdk-prerequirements.md) section, the [installation](./sdk-installation.md) section and the selected parts of the [configuration](./sdk-configuration.md) section.

[GENERAL CAPIF USAGE FLOW](./images/Flujo%20completo-OPENCAPIF%20ACTUAL.jpg)

This repository includes 2 different modes to test OpenCAPIF SDK:

- **Development usage**: import SDK in your code and start ... Within nf-sample folder, it is provided a sample application leveraging

- **Manual usage**: use a set of python scripts to test step by step all implemented procedures. All of them are provided at scripts folder

1 - First it is required to complete the utilities file with the absolute paths of target environment in order to complete the configuration of the SDK:
- NOTE register file is not needed for the use of the SDK,

2 - Then it is needed to fill out config files depending on the features required to be used from the SDK.

CAPIF is designed to use using two different roles:

- [As an invoker](#as-an-invoker)
- [As an provider](#as-an-provider)
- [Other features](#other-features)

# As an invoker

The common path to follow using CAPIF in order to get an API token of the service it's wanted to use is by following this steps:

- register_and_onboard_Invoker() // Script invoker_capif_connector.py  

Simplifies the process of onboarding for Invoker users

![Invoker_onboard](./images/Invoker_onboarding.png)

- discover() // Script invoker_service_discover.py
In this functionality it could be used [Discover_filter.json](./sdk-configuration.md) to retrieve only the access of the API's it's wanted to access

![Invoker_discover](./images/Invoker_discover.png)

- get_tokens() // Script invoker_service_get_token.py

After the Discovery, this functionality simplifies the way of getting created their propperly security context for each of the services and adquiring the access token to use the final APIs

![Invoker_get_token](./images/invoker_get_token.png)

- update_Invoker() and offboard_and_deregister_Invoker() // invoker_capif_connector_update.py and invoker_capif_connector_offboarding.py

For using this features we must have onboard as an invoker previusly.

![Invoker_update-offboard](./images/invoker_update-offboard.png)

## Important information for Invoker consumer

In the `invoker_folder`, it will be located several folders with each `capif_username` you have onboarded as a provider. For each folder, you could find:

-   `Capif_api_security_context_details.json`: This file contains the information of your invoker. It will contain:
        
    1. Your `api_invoker_id`.
    2. If you have already used the Service Discovery Functionality, you will find all the available APIs with their information.
    3. If you have already used the Service Get Token functionality, you will find your access token for using the APIs you have already discovered.

# As an provider
The common path to follow using CAPIF in order to publish an API is by following this steps:

- register_and_onboard_provider() // Script provider_capif_connector.py

Simplifies the process of onboarding for Provider users,also has the capability to register several APF's and AEF's if its necesary

![Provider_onboard](./images/provider_onboarding.png)

[CAPIF_Publish_Service_API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Publish_Service_API.yaml) 

For using the Publish Service is mandatory to fullfill certain fields of the [Publish.json](./sdk-configuration.md) file

- publish_services(service_api_description_json_full_path) // Script provider_publish_api.py

    Simplifies the process of publishing an API. Also has the capability to chose which APF and AEF's will be used to publish the API

    Mandatory fields:
    - PublisherAPFid
    - PublisherAEFsids

- unpublish_service(service_api_description_json_full_path) // Script provider_unpublish_api.py

    Simplifies the process of deleting an API

    Mandatory fields:
    - ServiceApiId
    - PublisherAPFid
    - PublisherAEFsids

- update_service(service_api_description_json_full_path) // Script provider_update_api.py

    Simplifies the process of updating an API. Also has the capability to chose which APF and AEF's will be used to update the API

    Mandatory fields:
    - ServiceApiId
    - PublisherAPFid
    - PublisherAEFsids

- get_service() // Script provider_get_published_api.py

    Simplifies the process of recieving the information of One service published previously

    Mandatory fields:
    - ServiceApiId
    - PublisherAPFid

- get_all_services() // Script provider_get_all_published_api.py

    Simplifies the process of recieving the information of all available services published previously

    Mandatory fields:
    - PublisherAPFid

![Provider_publish](./images/provider_publish.png)

- update_provider() and offboard_and_deregister_provider() // provider_capif_connector_update.py and provider_capif_connector_offboarding.py

For using this features we must have onboard as a provider previusly.

![Provider_update-offboard](./images/provider_update-offboard.png)

## Important information for Provider consumer

In the `provider_folder`, it will be located several folders with each `capif_username` you have onboarded as a provider, for each folder it is created by SDK this files:

- `Capif_provider_details.json` : Contains all the APFs and AEFs ids that have already onboarded with this capif_username
- `CAPIF_provider_api_description_sample.json` : If it's already published or updated an API, It will be available a copy of your last payload.
- `Service_received.json` : If it's alread used the get an api or get all apis functionality, It will be available the response to your request.
- `Published-Apis.json` : Constains the currently published APIs with their ApiId





# Other features

Apart from the SDK core, there are available different functionalities for development purposes:

- Script register_and_login.py

Facilitates the logging process for admin users and creates a CAPIF user,


- Script deregister_and_login.py 

Facilitates the logging process for admin users and eliminates a CAPIF user.

![Descripción de la imagen](./images/Flujo%20completo-SDK%20ACTUAL%20CON%20REGISTER.jpg)







