

# OpenCAPIF SDK

![OpenCAPIF icon](./doc/images/OpenCAPIF-icon.jpg)

This repository develops a Python Software Development Kit(SDK) which focuses on connecting to OpenCAPIF in a simple way, lowering integration complexity and allowing developers to focus on Network Applications (NetApps) or services development. 

OpentCAPIF SDK provides a set of libraries to enable either CAPIF provider and invoker roles, and other functions to simplify procedures calls towards OpenCAPIF entity.

Current version of OpenCAPIF SDK is compatible with following publicly available releases:
- [OpenCAPIF Release 1.0](https://ocf.etsi.org/documentation/v1.0.0-release/)


# OpenCAPIF SDK features

OpenCAPIF SDK brings a set of functions to integrate with the 5G Core's function CAPIF, as defined in [3GPP Technical Specification (TS) 29.222 V18.5.0 Common API Framework for 3GPP Northbound APIs](https://www.etsi.org/deliver/etsi_ts/129200_129299/129222/18.05.00_60/ts_129222v180500p.pdf). This section shows the mapping between the Python functions available in this SDK and the CAPIF OpenAPI APIs defined the reference standard:

| **CAPIF API**                                   | **OpenCAPIF SDK function**                                  |
|-------------------------------------------------|-------------------------------------------------------------|
| onboardedInvokers (POST)                        | register_and_onboard_Invoker()                              |
| Update_API_Invoker                              | update_Invoker()                                            |
| Offboard_API_Invoker                            | offboard_and_deregister_Invoker()                           |
| Onboard_API_Provider                            | register_and_onboard_provider()                             |
| Update_API_Provider                             | update_service()                                            |
| Offboard_API_Provider                           | offboard_and_deregister_nef()                               |
| Discover_Service_API                            | discover()                                                  |
| Publish_Service_API                             | publish_services(service_api_description_json_full_path)    |
| Unpublish_Service_API                           | unpublish_service(service_api_description_json_full_path)   |
| Update_Service_API                              | update_service(service_api_description_json_full_path)      |
| Get_Service_API                                 | get_service()                                               |
| Get_All_Service_API                             | get_all_services()                                          |
| Obtain_Authorization                            | discover()                                                  |

NOTE: Above mentioned CAPIF APIs are defined in these 3GPP references: \
- [CAPIF Invoker API specification](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_API_Invoker_Management_API.yaml)
- [CAPIF Provider API specification](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_API_Provider_Management_API.yaml)
- [CAPIF Discover API specification](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Discover_Service_API.yaml)
- [CAPIF Publish API specification](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Publish_Service_API.yaml) 

# Table of Contents
 1. [OpenCAPIF SDK Prerequeriments](./doc/sdk-prerequirements.md)
 2. [OpenCAPIF SDK Installation](./doc/sdk-installation.md)
 3. [OpenCAPIF SDK Configuration](./doc/sdk-configuration.md)
 4. [OpenCAPIF SDK Usage](./doc/sdk-usage.md)
 5. [OpenCAPIF SDK known issues](./doc/sdk-issues.md)


