from sdk import CAPIFInvokerConnector
import sys
import os
import utilities

# Añadir el directorio del SDK al PYTHONPATH usando una ruta relativa
script_dir = os.path.dirname(os.path.abspath(__file__))  # Directorio actual del script
sdk_path = os.path.join(script_dir, '..', 'sdk')  # Subir un nivel y apuntar a 'sdk'
sys.path.insert(0, sdk_path)


def showcase_capif_connector():
    """
        This method showcases how one can use the CAPIFConnector class.
        This class is intended for use within the evolved5G Command Line interface.
        It is a low level class part of the SDK that is not required to use while creating invokers
    """

    capif_connector = CAPIFInvokerConnector(config_file=utilities.get_config_file())

    capif_connector.update_invoker()
    print("COMPLETED")


if __name__ == "__main__":
    # Let's register invoker to CAPIF. This should happen exactly once
    showcase_capif_connector()
