
# OpenCAPIF SDK Development Environment Installation

Currently, the OpenCAPIF SDK is only available by downloading this repository and performing a manual installation. In the future, an OpenCAPIF SDK package will be released for easier installation.

Before proceeding, ensure you have fulfilled the necessary [requirements](../README.md#opencapif-sdk-requirements).

Follow the steps below to install the OpenCAPIF SDK for development purposes:

## Requisites

- Developers must have the following tools installed:
  - **pyenv**

## Installation Steps

### 1. Set Up a Python Environment with `pyenv`

Follow these steps to create and activate a virtual environment using `pyenv`:

```bash
# Install Python 3.12 using pyenv
pyenv install 3.12

# Create a virtual environment for the SDK
pyenv virtualenv 3.12 pesp_sdk_env

# Activate the virtual environment
source path/to/.pyenv/versions/pesp_sdk_env/bin/activate
```

OPTIONAL step: sometimes Apple Mac shells raise issues while finding the shell path. If this happens, try this command:

    ```console
    export PATH="$HOME/.pyenv/bin:$PATH"
    eval "$(pyenv init --path)"
    eval "$(pyenv init -)"
    eval "$(pyenv virtualenv-init -)"
    ```
OPTIONAL step: For Arm64 architecture sometimes will appear this problem 

    ```Last 10 log lines:
        __locale_localeconv in _localemodule.o
        __locale_localeconv in _localemodule.o
        __locale_localeconv in _localemodule.o
        __locale_localeconv in _localemodule.o
    "_libintl_textdomain", referenced from:
        __locale_textdomain in _localemodule.o
    ld: symbol(s) not found for architecture arm64
    clang: error: linker command failed with exit code 1 (use -v to see invocation)
    make: *** [Programs/_freeze_module] Error 1
    make: *** Waiting for unfinished jobs....´´´


This article explains how to solve it [here](https://laict.medium.com/install-python-on-macos-11-m1-apple-silicon-using-pyenv-12e0729427a9)  



2. Install the opencapif_sdk with pip in the environment:

```console
pip install opencapif_sdk
```

**Congratulations!** The installation of OpenCAPIF SDK has finished.