import utilities
from opencapif_sdk import capif_provider_connector, capif_provider_event_feature


def showcase_capif_connector():
    """
        This method showcases how one can use the CAPIFConnector class.
    """
    provider = capif_provider_connector(config_file=utilities.get_config_file())
    
    id = provider.provider_capif_ids["AEF-1"]

    events = capif_provider_event_feature(config_file=utilities.get_config_file())

    events.create_subscription(name="Servicio_2", id=id)

    events.update_subcription(name="Servicio_2", id=id)

    events.delete_subscription(name="Servicio_2", id=id)

    print("COMPLETED")


if __name__ == "__main__":
    # Register invoker to CAPIF. This should happen exactly once
    showcase_capif_connector()
