import sys
import os
import utilities

# Add the SDK directory to PYTHONPATH using a relative path
script_dir = os.path.dirname(os.path.abspath(__file__))  # Current script directory
sdk_path = os.path.join(script_dir, '..', 'sdk')  # Go up one level and point to 'sdk'
sys.path.insert(0, sdk_path)
from sdk import capif_provider_connector
# Now import the classes from your sdk.py file


def showcase_capif_nef_connector():
    """

    """
    capif_connector = capif_provider_connector(config_file=utilities.get_config_file())

    capif_connector.onboard_provider()

    print("COMPLETED")


if __name__ == "__main__":
    # Register a NEF to CAPIF. This should happen exactly once
    showcase_capif_nef_connector()
