# OpenCAPIF SDK usage

OpenCAPIF SDK implements this set of features to easily integrate an application with CAPIF NF either manually or integrating SDK library directly within app code.

Before using it, it is required to have fullfilled the [requirements](./sdk-prerequirements.md) section, the [installation](./sdk-installation.md) section and the selected parts of the [configuration](./sdk-configuration.md) depending on the CAPIF role the NetApp is going to play.


![GENERAL CAPIF USAGE FLOW](./images/Flujo%20completo-OPENCAPIF%20ACTUAL.jpg)

This repository includes 2 different modes to test OpenCAPIF SDK:

- **Development usage**: import SDK in your code and start ... Within [nf-sample folder](../netapp-samples/), it is provided a sample application leveraging

- **Manual usage**: use a set of python [scripts](../scripts/) to test step by step all implemented procedures. All of them are provided at scripts folder

    -  For Manual usage it is required to complete the utilities file with the absolute paths of target environment in order to complete the configuration of the SDK:

**NOTE**:register file is not needed for the use of the SDK

**IMPORTANT**:It is needed to fill out config files depending on the features required to be used from the SDK.Please if you didn't fullfil this file, go to the [Configuration Section](./sdk-configuration.md)

# Table of contents

CAPIF is designed to use using two different roles:



- [As an Invoker](#as-an-invoker)
    - [Important Information for Invoker](#important-information-for-invoker-consumer)
    - [Onboard Invoker](#onboard_invoker--script-invoker_capif_connectorpy)
    - [Discover API](#discover--script-invoker_service_discoverpy)
    - [Get Tokens](#get_tokens--script-invoker_service_get_tokenpy)
    - [Update and Offboard Invoker](#update_invoker-and-offboard_and_deregister_invoker--invoker_capif_connector_updatepy-and-invoker_capif_connector_offboardingpy)
- [As a Provider](#as-a-proxvider)
    - [Important Information for Provider](#important-information-for-provider-consumer)
    - [Onboard Provider](#onboard_provider--script-provider_capif_connectorpy)
    - [Publish Services](#publish_services--script-provider_publish_apipy)
    - [Unpublish Services](#unpublish_service--script-provider_unpublish_apipy)
    - [Update Services](#update_service--script-provider_update_apipy)
    - [Get Published Services](#get_service--script-provider_get_published_apipy)
    - [Get All Published Services](#get_all_services--script-provider_get_all_published_apipy)
    - [Update and Offboard Provider](#update_provider-and-offboard_provider--provider_capif_connector_updatepy-and-provider_capif_connector_offboardingpy)
- [Other Features](#other-features)
    - [Register and Login](#script-register_and_loginpy)
    - [Deregister and Login](#script-deregister_and_loginpy)

# As an invoker

The common path to follow using CAPIF in order to get an API token of the service it's wanted to use is by following this steps:
## Important information for Invoker consumer

In the `invoker_folder`, it will be located several folders with each `capif_username` you have onboarded as a provider. For each folder, you could find:

-   `Capif_api_security_context_details.json`: This file contains the information of your invoker. It will contain:
        
    1. Your `api_invoker_id`.
    2. If you have already used the Service Discovery Functionality, you will find all the available APIs with their information.
    3. If you have already used the Service Get Token functionality, you will find your access token for using the APIs you have already discovered.


### onboard_invoker() // Script invoker_capif_connector.py  

Simplifies the process of onboarding for Invoker users

![Invoker_onboard](./images/Invoker_onboarding.png)

### discover() // Script invoker_service_discover.py
In this functionality it could be used [discover_filter](./sdk-configuration.md) to retrieve only the access of the API's it's wanted to query

It is mandatory to have onboarded as a [invoker](#onboard_invoker--script-invoker_capif_connectorpy) before

![Invoker_discover](./images/Invoker_discover.png)

### get_tokens() // Script invoker_service_get_token.py

This functionality simplifies the way of getting created their propperly security context for each of the services and adquiring the access token to use the final APIs.

This functionality **requires** to to have onboarded as a [invoker](#onboard_invoker--script-invoker_capif_connectorpy) before and run the [discover](#discover--script-invoker_service_discoverpy) function at least once before.

![Invoker_get_token](./images/invoker_get_token.png)

### update_invoker() and offboard_and_deregister_Invoker() // invoker_capif_connector_update.py and invoker_capif_connector_offboarding.py

For using this features we must have [onboarded as an invoker](#onboard_invoker--script-invoker_capif_connectorpy) previusly.

![Invoker_update-offboard](./images/invoker_update-offboard.png)


# As a provider
The common path to follow using CAPIF in order to publish an API is by following this steps:

## Important information for Provider consumer

In the `provider_folder`, it will be located several folders with each `capif_username` you have onboarded as a provider, for each folder it is created by SDK this files:

- `Capif_provider_details.json` : Contains all the APFs and AEFs ids that have already onboarded with this capif_username
- `CAPIF_provider_api_description_sample.json` : If it's already published or updated an API, It will be available a copy of your last payload.
- `Service_received.json` : If it's alread used the get an api or get all apis functionality, It will be available the response to your request.
- `Published-Apis.json` : Constains the currently published APIs with their ApiId


### onboard_provider() // Script provider_capif_connector.py

Simplifies the process of onboarding for Provider users,also has the capability to register several APF's and AEF's if its necesary

![Provider_onboard](./images/provider_onboarding.png)

[CAPIF_Publish_Service_API](https://github.com/jdegre/5GC_APIs/blob/Rel-18/TS29222_CAPIF_Publish_Service_API.yaml) 

For using the Publish Service is mandatory to fullfill certain fields of the [Publish.json](./sdk-configuration.md) file

### publish_services() // Script provider_publish_api.py

Simplifies the process of publishing an API. Also has the capability to chose which APF and AEF's will be used to publish the API.

It is mandatory to have [onboarded as a provider](#onboard_provider--script-provider_capif_connectorpy) before 

    Mandatory fields:
    - PublisherAPFid
    - PublisherAEFsids

### unpublish_service() // Script provider_unpublish_api.py

Simplifies the process of deleting an API

It is mandatory to have onboarded as a [provider](#onboard_provider--script-provider_capif_connectorpy) before and to have [published any service](#publish_services--script-provider_publish_apipy) before 

    Mandatory fields:
    - ServiceApiId
    - PublisherAPFid
    - PublisherAEFsids

### update_service() // Script provider_update_api.py

Simplifies the process of updating an API. Also has the capability to chose which APF and AEF's will be used to update the API.

It is mandatory to have onboarded as a [provider](#onboard_provider--script-provider_capif_connectorpy) before and to have [published any service](#publish_services--script-provider_publish_apipy) before

    Mandatory fields:
    - ServiceApiId
    - PublisherAPFid
    - PublisherAEFsids

### get_service() // Script provider_get_published_api.py

Simplifies the process of recieving the information of One service published previously in Published-Apis.json

It is mandatory to have onboarded as a [provider](#onboard_provider--script-provider_capif_connectorpy) before and to have [published any service](#publish_services--script-provider_publish_apipy) before

    Mandatory fields:
    - ServiceApiId
    - PublisherAPFid

### get_all_services() // Script provider_get_all_published_api.py

Simplifies the process of recieving the information of all available services published previously in Published-Apis.json

It is mandatory to have onboarded as a [provider](#onboard_provider--script-provider_capif_connectorpy) before and to have [published any service](#publish_services--script-provider_publish_apipy) before

    Mandatory fields:
    - PublisherAPFid

![Provider_publish](./images/provider_publish.png)

### update_provider() and offboard_provider() // provider_capif_connector_update.py and provider_capif_connector_offboarding.py

For using this features we must have onboard as a provider previusly.

It is mandatory to have onboarded as a [provider](#onboard_provider--script-provider_capif_connectorpy) before

![Provider_update-offboard](./images/provider_update-offboard.png)



# Other features

Apart from the SDK core, there are available different functionalities for development purposes:

### Script register_and_login.py

Facilitates the logging process for admin users and creates a CAPIF user,


### Script deregister_and_login.py 

Facilitates the logging process for admin users and eliminates a CAPIF user.

![Descripción de la imagen](./images/Flujo%20completo-SDK%20ACTUAL%20CON%20REGISTER.jpg)







