
from cmd import Cmd
from capif_ops.invoker_previous_register import PreviousRegister
from capif_ops.invoker_register_to_capif import RegisterInvoker
from capif_ops.invoker_discover_service import  DiscoverService
from capif_ops.invoker_secutiry_context import InvokerSecurityContext
from capif_ops.invoker_get_security_auth import InvokerGetSecurityAuth
from capif_ops.invoker_delete import RemoveInvoker
from capif_ops.invoker_get_auth import PreviousAuth
from capif_ops.invoker_remove_security_context import InvokerRemoveSecurityContext
from capif_ops.invoker_to_service import InvokerToService
from capif_ops.invoker_remove_user import RemoveUser
from capif_ops.invoker_register_events import AddEvents
from capif_ops.invoker_admin_login import LoginAdmin
from capif_ops.invoker_refresh_admin_token import refreshAdmin
import subprocess
import shlex
from art import *
from termcolor import colored

prev_register = PreviousRegister()
regiter_capif = RegisterInvoker()
discover_service = DiscoverService()
register_security_context = InvokerSecurityContext()
security_context_auth = InvokerGetSecurityAuth()
remove_invoker = RemoveInvoker()
invoker_auth = PreviousAuth()
remove_security_service = InvokerRemoveSecurityContext()
invoker_service = InvokerToService()
remove_user = RemoveUser()
register_events = AddEvents()
admin_login = LoginAdmin()
refresh_admin = refreshAdmin()



class CAPIFProvider(Cmd):

  def __init__(self):
        Cmd.__init__(self)
        self.prompt = "> "
        self.intro = tprint("Welcome  to  Invoker  Console")

  def emptyline(self):
        """Do nothing on empty input line"""
        pass

  # def preloop(self):
  #   state = prev_register.execute_previous_register_invoker("")
  #   self.previous_register_state = state

  def precmd(self, line):

    #line = line.lower()
    args = shlex.split(line)


    if len(args) >= 1 and args[0] in ["goodbye"]:
        print("The first argument is username")
        return ""

    elif len(args) >= 1 and args[0] not in ["->", "wall", "follows", "exit", "help"]:
        pass

    return line
  
  def do_login_admin(self, input):
    'Login with admin credentials to obtain the admin tokens'
    args = input.split()
    if len(args) < 2:
      print(colored("\nLogin admin needs the username and password of the administrator.\n", "red"))
    else:
      arg1 = args[0]
      arg2 = args[1]
      arg3 = args[2] if len(args) > 2 else None
      admin_login.execute_login_admin(arg1, arg2, arg3)

  def do_refresh_admin(self, input):
    'Refresh the admin access token'
    refresh_admin.execute_refresh_admin(input)
  
  def do_register_user(self, input):
    'Register an user from the registry service'
    prev_register.execute_previous_register_invoker(input)

  def do_register_invoker(self, input):
    'Register invoker to CAPIF'
    args = input.split()
    if len(args) < 1:
      print(colored("\nRegister invoker need a name\n", "red"))
    else:
      arg1 = args[0]
      arg2 = args[1] if len(args) > 1 else None
      regiter_capif.execute_register_invoker(arg1, arg2)

  def do_register_events(self, input):
    'Register events for invoker'
    register_events.execute_add_events(input)

  def do_discover_service(self, input):
    'Discover all services published in CAPIF'
    discover_service.execute_discover_service(input)

  def do_register_security_context(self, input):
    'Create security context to use services'
    args = input.split()
    if len(args) < 1:
      print(colored("\nRegister security context needs the name of an api\n", "red"))
    else:
      if args[-1] != "debug":
         arg1 = args
         arg2 = None
      else:
         arg1 = args[:-1]
         arg2 = args[-1]
      register_security_context.execute_register_security_context(arg1, arg2)


  def do_get_security_auth(self, input):
    "If you select Oauth as security method use this command to obtain jwt token to access service"
    args = input.split()
    if len(args) < 1:
      print(colored("\nGet security auth needs the name of an api\n", "red"))
    else:
      if args[-1] != "debug":
         arg1 = args
         arg2 = None
      else:
         arg1 = args[:-1]
         arg2 = args[-1]
      security_context_auth.execute_get_security_auth(arg1, arg2)

  def do_get_auth(self, input):
    'Get jwt token to register invoker in CAPIF (Optional, only if token expires)'
    invoker_auth.execute_get_auth(input)

  def do_remove_security_context(self, input):
    print("Not implemented yet")
    #remove_security_service.execute_remove_security_context(input)

  def do_remove_invoker(self, input):
    "Remove invoker from CAPIF"
    remove_invoker.execute_remove_invoker(input)

  def do_call_service(self, input):
    "Test invocation os service API"
    args = input.split()
    if len(args) < 4:
      print(colored("\nCall service needs the name of an api and the route of json file\n", "red"))
    else:
      api_name = args[0]
      method = args[1]
      endpoint = args[2]
      json_route = args[3]
      flag = args[4] if len(args) > 4 else None
      invoker_service.execute_invoker_to_service(api_name, method, endpoint, json_route, flag)
  
  def do_remove_user(self, input):
    'Delete a user from the registry service'
    remove_user.execute_remove_user(input)

  def do_exit(self, input):
    print('\nExiting...')
    return True


if __name__ == '__main__':
    try:
        CAPIFProvider().cmdloop()
    except KeyboardInterrupt:
        print('\nExiting...')