from flask import Flask, request, jsonify
import json
from termcolor import colored

app = Flask(__name__)

@app.route('/', methods=['POST'])
def recibir_solicitud():
    try:
        response = request.get_json()

        #print(json.dumps(response, indent=2))
        print(colored("\n''''''''''EVENT'''''''''''''''''","green"))
        print(colored(f"{json.dumps(response, indent=2)}","green"))
        print(colored("''''''''''EVENT'''''''''''''''''\n","green"))
        print(colored(f"Response message: ","green"))
        return jsonify({"\nmessage": "received"})

    except Exception as e:
        return jsonify({"error": str(e)})

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=2223)