import requests
import json
import configparser
import os
from termcolor import colored
import warnings
from urllib3.exceptions import InsecureRequestWarning

class RemoveUser():
    
    def __delete_user(self, register_ip, register_port, uuid, access_token, log_level):

        url = "https://{}:{}/deleteUser/{}".format(register_ip, register_port, uuid)

        headers = {
                'Authorization': 'Bearer {}'.format(access_token),
            }

        try:
            print(colored("\nRemoving User\n", "yellow"))
            if log_level == "debug":
                if log_level == "debug":
                    print(colored("''''''''''REQUEST'''''''''''''''''","yellow"))
                    print(colored(f"Request: to {url}","yellow"))
                    print(colored(f"User uuid: {uuid}", "yellow"))
                    print(colored("''''''''''REQUEST'''''''''''''''''","yellow"))

            response = requests.request("DELETE", url, headers=headers, verify=False)

            if log_level == "debug":
                print(colored("\n''''''''''RESPONSE'''''''''''''''''","green"))
                print(colored(f"Response to: {response.url}","green"))
                print(colored(f"Response Headers: {response.headers}","green"))
                print(colored(f"Response Status code: {response.status_code}","green"))
                print(colored("''''''''''RESPONSE'''''''''''''''''","green"))

            #response.raise_for_status()
            #response_payload = json.loads(response.text)
            print(colored("User Removed\n","green"))

        except requests.exceptions.HTTPError as err:
            raise Exception(err.response.text, err.response.status_code)

    def execute_remove_user(self, log_level):

        config = configparser.ConfigParser()
        config.read('capif_ops/config_files/credentials.properties')

        register_ip = os.getenv('REGISTER_HOSTNAME')
        register_port = os.getenv('REGISTER_PORT')

        with open('capif_ops/config_files/demo_values.json', 'r') as archivo:
            content = archivo.read()
        
        if "user_uuid" not in content:
            print(colored("\nUser uuid not found.\n", "red"))
            return True
        if "access_token" not in content:
            print(colored("\nYou need the admin access token to remove an user. Use login_admin command to receive the token.\n", "red"))
            return True
        
        try:
            self.__delete_user(register_ip, register_port, content["user_uuid"], content["access_token"], log_level)
            
        except Exception as e:
            status_code = e.args[0]
            if status_code == 401:
                print(colored("\nAccess token expired.\n", "red"))
            else:
                print(colored(f"\n{e}.\n", "red"))


        with open('capif_ops/config_files/demo_values.json', 'w') as archivo:
            archivo.write('{}')

        if os.path.exists("capif_ops/certs/dummy.crt"):
            os.remove("capif_ops/certs/dummy.crt")
        if os.path.exists("capif_ops/certs/invoker_private_key.key"):
            os.remove("capif_ops/certs/invoker_private_key.key")
        if os.path.exists("capif_ops/certs/ca.crt"):
            os.remove("capif_ops/certs/ca.crt")

        #First we need register exposer in CAPIF

        


        return True
