import requests
import json
import configparser
import os
from termcolor import colored


class AddEvents():

    def __add_events_to_capif(self, capif_ip, apf_id, log_level):

        print(colored("\nSubscribing to events", "yellow"))

        url = 'https://{}/capif-events/v1/{}/subscriptions'.format(capif_ip, apf_id)
        payload = open('capif_ops/config_files/events_values.json', 'rb')
        payload_dict = json.load(payload)

        headers = {
            'Content-Type': 'application/json'
        }

        payload = json.dumps(payload_dict, indent=2)

        try:
            if log_level == "debug":
                print(colored("''''''''''REQUEST'''''''''''''''''","yellow"))
                print(colored(f"Request: to {url}","yellow"))
                print(colored(f"Request Headers: {headers}", "yellow"))
                print(colored(f"Request Body: {payload}", "yellow"))
                print(colored(f"''''''''''REQUEST'''''''''''''''''\n", "yellow"))

            response = requests.request("POST", url, headers=headers, data=json.dumps(payload_dict), cert=('capif_ops/certs/dummy.crt', 'capif_ops/certs/invoker_private_key.key'), verify=False)
            response.raise_for_status()
            response_payload = json.loads(response.text)


            if log_level == "debug":
                print(colored("''''''''''RESPONSE'''''''''''''''''","green"))
                print(colored(f"Response to: {response.url}","green"))
                print(colored(f"Response Headers: {response.headers}","green"))
                print(colored(f"Response: {json.dumps(response.json(), indent=2)}","green"))
                print(colored(f"Response Status code: {response.status_code}","green"))
                print(colored("Success, events subscribed ","green"))
                print(colored("''''''''''RESPONSE'''''''''''''''''","green"))

            header = response.headers.get("Location")

            return header.split('/')[len(header.split('/'))-1]
        except requests.exceptions.HTTPError as err:
            message = json.loads(err.response.text)
            status = err.response.status_code
            raise Exception(message, status)


    def execute_add_events(self, log_level):

        config = configparser.ConfigParser()
        config.read('capif_ops/config_files/credentials.properties')

        with open('capif_ops/config_files/demo_values.json', 'r') as demo_file:
            demo_values = json.load(demo_file)

        capif_ip = os.getenv('CAPIF_HOSTNAME')


        #Add the event in CAPIF
        try:
            subscription_id = self.__add_events_to_capif(capif_ip, demo_values['invokerID'], log_level)
            demo_values['subscription_id']= subscription_id
            print(colored("\nEvents subscription id: {}\n".format(subscription_id),"green"))
            with open('capif_ops/config_files/demo_values.json', 'w') as outfile:
                json.dump(demo_values, outfile)
        except Exception as e:
            print(colored(f"\n{e}\n", "red"))
        return True