import requests
import json
import configparser
import os
from termcolor import colored
import warnings
from urllib3.exceptions import InsecureRequestWarning


class PreviousRegister():

    warnings.filterwarnings("ignore", category=InsecureRequestWarning)

    def __register_invoker_to_capif(self, register_ip, register_port, username, password, description, email, enterprise, country, purpose, phone_number, website, access_token, log_level):

            url = "https://{}:{}/createUser".format(register_ip,register_port)

            payload = dict()
            payload['username'] = username
            payload['password'] = password
            payload['enterprise'] = enterprise
            payload['description'] = description
            payload['email'] = email
            payload['country'] = country
            payload['purpose'] = purpose
            payload['phone_number'] = phone_number
            payload['website'] = website

            headers = {
                'Authorization': 'Bearer {}'.format(access_token),
                'Content-Type': 'application/json'
            }

            print(colored("\nRegistering user", "yellow"))
            if log_level == "debug":
                print(colored("''''''''''REQUEST'''''''''''''''''","yellow"))
                print(colored(f"Request: to {url}","yellow"))
                print(colored(f"Request Headers: {headers}", "yellow"))
                print(colored(f"Request Body: {payload}", "yellow"))
                print(colored("''''''''''REQUEST'''''''''''''''''","yellow"))

            try:
                response = requests.request("POST", url, headers=headers, data=json.dumps(payload), verify=False)
                response.raise_for_status()
                if log_level == "debug":
                    print(colored("\n''''''''''RESPONSE'''''''''''''''''","green"))
                    print(colored(f"Response to: {response.url}","green"))
                    print(colored(f"Response Headers: {response.headers}","green"))
                    print(colored(f"Response: {json.dumps(response.json(), indent=2)}","green"))
                    print(colored(f"Response Status code: {response.status_code}","green"))
                    print(colored("''''''''''RESPONSE'''''''''''''''''","green"))
                response_payload = json.loads(response.text)

                return response_payload['uuid']
            except requests.exceptions.HTTPError as err:
                raise Exception(err.response.status_code)

    def execute_previous_register_invoker(self, log_level):

        config = configparser.ConfigParser()
        config.read('capif_ops/config_files/credentials.properties')

        username = config.get("credentials", "invoker_username")
        password = config.get("credentials", "invoker_password")
        description = config.get("credentials", "invoker_description")
        email = config.get("credentials", "invoker_email")
        enterprise = config.get("credentials", "invoker_enterprise")
        country = config.get("credentials", "invoker_country")
        purpose = config.get("credentials", "invoker_purpose")
        phone_number = config.get("credentials", "invoker_phone")
        website = config.get("credentials", "invoker_web")

        register_ip = os.getenv('REGISTER_HOSTNAME')
        register_port = os.getenv('REGISTER_PORT')

        with open('capif_ops/config_files/demo_values.json', 'r') as demo_file:
            demo_values = json.load(demo_file)
        
        if "access_token" not in demo_values:
            print(colored("\nYou need the admin access token to create an user. Use login_admin command to receive the token.\n", "red"))
            return True

        #First we need register invoker in CAPIF
        try:
            uuid = self.__register_invoker_to_capif(register_ip, register_port, username, password, description, email, enterprise, country, purpose, phone_number, website, demo_values["access_token"], log_level)
            demo_values['user_uuid'] = uuid
            #print(colored(f"NetAppID: {netappID}\n","yellow"))
            #print("provider ID: {}".format(providerID))

            with open('capif_ops/config_files/demo_values.json', 'w') as outfile:
                json.dump(demo_values, outfile)

            
        except Exception as e:
            status_code = e.args[0]
            if status_code == 401:
                print(colored("\nAccess token expired.\n", "red"))
            elif status_code == 409:
                print(colored("\nThe user is already registered\n", "red"))
            else:
                print(colored(f"\n{e}.\n", "red"))

        return True