import requests
import json
import configparser
import os
from termcolor import colored

class PreviousAuth():

    def __get_capif_auth(self, register_ip, register_port, username, password, log_level):

            #url = "https://register:8084/getauth".format(capif_port)
            url = "https://{}:{}/getauth".format(register_ip, register_port)

            try:
                print(colored("\nGetting authorization token", "yellow"))
                if log_level == "debug":
                    print(colored("''''''''''REQUEST'''''''''''''''''","yellow"))
                    print(colored(f"Request: to {url}","yellow"))
                    print(colored(f"Request user: {username}/{password}", "yellow"))
                    print(colored("''''''''''REQUEST'''''''''''''''''","yellow"))
                response = requests.request("GET", url, verify=False, auth=(username, password))

                response.raise_for_status()
                response_payload = json.loads(response.text)
                if log_level == "debug":
                    print(colored("\n''''''''''RESPONSE'''''''''''''''''","green"))
                    print(colored(f"Response to: {response.url}","green"))
                    print(colored(f"Response Headers: {response.headers}","green"))
                    print(colored(f"Response: {json.dumps(response.json(), indent=2)}","green"))
                    print(colored(f"Response Status code: {response.status_code}","green"))
                    print(colored("''''''''''RESPONSE'''''''''''''''''","green"))
                return response_payload

            except requests.exceptions.HTTPError as err:
                raise Exception(err.response.text, err.response.status_code)


    def execute_get_auth(self, log_level):

        config = configparser.ConfigParser()
        config.read('capif_ops/config_files/credentials.properties')

        username = config.get("credentials", "invoker_username")
        password = config.get("credentials", "invoker_password")

        register_ip = os.getenv('REGISTER_HOSTNAME')
        register_port = os.getenv('REGISTER_PORT')

        with open('capif_ops/config_files/demo_values.json', 'r') as demo_file:
            demo_values = json.load(demo_file)

        #First we need register exposer in CAPIF
        try:
            response = self.__get_capif_auth(register_ip, register_port, username, password, log_level)
            demo_values['capif_access_token'] = response["access_token"]
            demo_values['ccf_api_onboarding_url'] = response["ccf_api_onboarding_url"]
            demo_values['ccf_discover_url'] = response["ccf_discover_url"]
            demo_values['ccf_onboarding_url'] = response["ccf_onboarding_url"]
            demo_values['ccf_publish_url'] = response["ccf_publish_url"]
            demo_values['ccf_security_url'] = response["ccf_security_url"]
            ca_root = response["ca_root"]
            with open('capif_ops/config_files/demo_values.json', 'w') as outfile:
                json.dump(demo_values, outfile)

            certification_file = open('capif_ops/certs/ca.crt', 'w')
            certification_file.write(ca_root)

            print(colored("\nCertificate ca_root, token and URLs received\n","green"))
        except Exception as e:
            status_code = e.args[0]
            if status_code == 409:
                print(colored("\nUser already registed. Continue with token request\n", "red"))
                print("User already registed. Continue with token request\n")
            else:
                print(colored(f"\n{e}.\n", "red"))

        return True