import requests
import json
import configparser
import os
from termcolor import colored
import warnings
from urllib3.exceptions import InsecureRequestWarning

class LoginAdmin():

    warnings.filterwarnings("ignore", category=InsecureRequestWarning)

    def __login_admin__(self, register_ip, register_port, user, passw, log_level):

        url = "https://{}:{}/login".format(register_ip,register_port)

        print(colored("\nLogin admin", "yellow"))
        if log_level == "debug":
            print(colored("''''''''''REQUEST'''''''''''''''''","yellow"))
            print(colored(f"Request: to {url}","yellow"))
            print(colored(f"Request admin credentials: {user}/{passw}", "yellow"))
            print(colored("''''''''''REQUEST'''''''''''''''''","yellow"))
        try:
            response = requests.request("POST", url, verify=False, auth=(user, passw))

            response.raise_for_status()
            if log_level == "debug":
                print(colored("\n''''''''''RESPONSE'''''''''''''''''","green"))
                print(colored(f"Response to: {response.url}","green"))
                print(colored(f"Response Headers: {response.headers}","green"))
                print(colored(f"Response: {json.dumps(response.json(), indent=2)}","green"))
                print(colored(f"Response Status code: {response.status_code}","green"))
                print(colored("''''''''''RESPONSE'''''''''''''''''","green"))
            response_payload = json.loads(response.text)
            return response_payload['refresh_token'], response_payload['access_token']
        except requests.exceptions.HTTPError as err:
                raise Exception(err.response.status_code)
    


    def execute_login_admin(self, admin_username, admin_pass, log_level):

        register_ip = os.getenv('REGISTER_HOSTNAME')
        register_port = os.getenv('REGISTER_PORT')

        if os.path.exists("capif_ops/config_files/demo_values.json"):

            with open('capif_ops/config_files/demo_values.json', 'r') as demo_file:
                demo_values = json.load(demo_file)
        else:
            demo_values = {}

        try:
            refresh_token, access_token = self.__login_admin__(register_ip, register_port, admin_username, admin_pass, log_level)
            demo_values['refresh_token'] = refresh_token
            demo_values['access_token']= access_token

            with open('capif_ops/config_files/demo_values.json', 'w') as outfile:
                json.dump(demo_values, outfile)

            print(colored(f"\nAccess token: {access_token} received.\n","green"))

        except Exception as e:
            status_code = e.args[0]
            if status_code == 401:
                print(colored(f"\nUnauthorized credentials.\n", "red"))
            else:
                print(colored(f"\n{e}.\n", "red"))

        return True
