# Introduction to the Helper Service

## Overview

CAPIF does not include any built-in mechanism to expose data via API. This makes it difficult to retrieve essential information such as the number of registered API Invokers, a list of available API Invokers, etc.

Without a dedicated tool, accessing this data requires direct database queries, making it inefficient and impractical.

## Helper Service

The Helper Service addresses this limitation by acting as an intermediary that exposes CAPIF’s stored data in a structured and accessible manner. This service provides APIs that allow users to query the CAPIF database and obtain valuable insights, such as:

- The total count and details of registered API Invokers and API Providers.
- A structured and API-driven way to retrieve CAPIF-related information.
- Simplified access to important data without the need for direct database interactions.
- Access to security contexts, helping manage authentication and authorization processes.
- Retrieval of event records, providing insight into CAPIF system activities.
- The ability to delete different CAPIF entities, facilitating resource management.
- Full control over CAPIF dynamic configuration, including:
    - Retrieving the current configuration.
    - Modifying specific parameters.
    - Adding or updating configuration settings dynamically.

By this Helper Service, CAPIF users can effortlessly retrieve and manage critical system information, improving overall visibility and efficiency.


## API Documentation

For a detailed API reference, please check the **Helper Service Swagger Documentation**:

➡️ [Helper Service API Documentation](../helper/swagger.md)
