# Test Plan for API Status Feature
At this documentation you will have all information and related files and examples of test plan for this feature.

## Test Case 1: Publish without apiStatus feature receive eventDetails with serviceAPIDescription

**Test ID**: ***api_status-1***

**Description**:

  This test case will check if an invoker subscribed to events **SERVICE_API_AVAILABLE** and **SERVICE_API_UNAVAILABLE**, with ***apiStatusMonitoring*** and ***Enhanced_event_report*** active, receive SERVICE_API_AVAILABLE in mockserver when api is published by a provider, containing apiIds and serviceAPIDescription at eventDetails, and the same when api is unpublished.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered with 2 aefs.
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:
  1. Register Invoker and Onboard Invoker at CCF.
  2. Register Provider at CCF with 2 aefs.
  3. Subscribe to **SERVICE_API_AVAILABLE** and **SERVICE_API_UNAVAILABLE**. ***Enhanced_event_report*** and ***apiStatusMonitoring*** **active** at supported features (binary 1100-> string **C**)
  4. Publish Service API at CCF:
     1. Supported Features with apiStatusMonitoring flag inactive (binary 0 0000 0000 -> string **000**)
     2. This API not includes "API Status" information at **service API Description**.
  5. Discover Service APIs by Invoker
     1. includes filter by query parameter **aef-id**
  6. Provider remove published API.

**Information of Test**:

  1. Perform [Invoker Onboarding]
  2. Perform [Provider Registration] with 2 aefs
  3. Event Subscription to SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE of provider previously registered:
       1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
       2. body [event subscription request body] with:
          1. events: **['SERVICE_API_AVAILABLE','SERVICE_API_UNAVAILABLE']**
          2. supportedFeatures: binary 1100 -> string **C**
       3. Use **Invoker Certificate**
  4. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with **service_1** and **service_2** apiNames and realted with aefId1 and aefId2.
       * supportedFeatures **000**
       * 2 profiles, one with each aef.
     * Use **APF Certificate**
  5. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**
  6. Remove published Service API:
     * Send **DELETE** to resource URL **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis/{SERVICE_API_ID}**
     * Use **APF Certificate**

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**
  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  3. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
        * 2 profiles with:
          * resourceName resource_1 and aefId1
          * resourceName resource_2 and aefId2
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response without **"apiStatus"** parameter.
  4. Response to Discover Request By Invoker:
     1. **200 OK** response.
     2. Response body must follow **DiscoveredAPIs** data structure:
        * Check if DiscoveredAPIs contains the API Published previously
          * Check if **NOT** contains the **apiStatus** keys
  5. Response to Remove published Service API at CCF:
     1. **204 No Content**
  6. Mock Server received messages must accomplish:
     1. **Two Events have been received**.
     2. Validate received events follow **EventNotification** data structure, with **apiIds** in **eventDetail** parameter.
        1. One should be **SERVICE_API_AVAILABLE** apiId of published API with **eventDetails** containing **apiIds** and **serviceAPIDescription** parameters.
        2. The other one must be **SERVICE_API_UNAVAILABLE** apiId of published API with **eventDetails** containing **apiIds** and **serviceAPIDescription** parameters.



## Test Case 2: Publish without apiStatus feature receive eventDetails without serviceAPIDescription

**Test ID**: ***api_status-2***

**Description**:

  This test case will check if an invoker subscribed to events **SERVICE_API_AVAILABLE** and **SERVICE_API_UNAVAILABLE**, with only ***Enhanced_event_report*** active, receive SERVICE_API_AVAILABLE in mockserver when api is published by a provider, containing apiIds at eventDetails, and the same when api is unpublished.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered with 2 aefs.
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:
  1. Register Invoker and Onboard Invoker at CCF.
  2. Register Provider at CCF with 2 aefs.
  3. Subscribe to **SERVICE_API_AVAILABLE** and **SERVICE_API_UNAVAILABLE**. ***Enhanced_event_report*** **active** at supported features (binary 0100-> string **4**)
  4. Publish Service API at CCF:
     1. Supported Features with apiStatusMonitoring flag inactive (binary 0 0000 0000 -> string **000**)
     2. This API not includes "API Status" information at **service API Description**.
  5. Discover Service APIs by Invoker
     1. includes filter by query parameter **aef-id**
  6. Provider remove published API.

**Information of Test**:

  1. Perform [Invoker Onboarding]
  2. Perform [Provider Registration] with 2 aefs
  3. Event Subscription to SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE of provider previously registered:
       1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
       2. body [event subscription request body] with:
          1. events: **['SERVICE_API_AVAILABLE','SERVICE_API_UNAVAILABLE']**
          2. supportedFeatures: binary 0100 -> string **4**
       3. Use **Invoker Certificate**
  4. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with **service_1** and **service_2** apiNames and realted with aefId1 and aefId2.
       * supportedFeatures **000**
       * 2 profiles, one with each aef.
     * Use **APF Certificate**
  5. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**
  6. Remove published Service API:
     * Send **DELETE** to resource URL **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis/{SERVICE_API_ID}**
     * Use **APF Certificate**

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**
  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  3. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
        * 2 profiles with:
          * resourceName resource_1 and aefId1
          * resourceName resource_2 and aefId2
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response without **"apiStatus"** parameter.
  4. Response to Discover Request By Invoker:
     1. **200 OK** response.
     2. Response body must follow **DiscoveredAPIs** data structure:
        * Check if DiscoveredAPIs contains the API Published previously
          * Check if **NOT** contains the **apiStatus** keys
  5. Response to Remove published Service API at CCF:
     1. **204 No Content**
  6. Mock Server received messages must accomplish:
     1. **Two Events have been received**.
     2. Validate received events follow **EventNotification** data structure, with **apiIds** in **eventDetail** parameter.
        1. One should be **SERVICE_API_AVAILABLE** apiId of published API with **eventDetails** containing **apiIds** parameter.
        2. The other one must be **SERVICE_API_UNAVAILABLE** apiId of published API with **eventDetails** containing **apiIds** parameter.

## Test Case 3: Publish without apiStatus feature receive eventDetails without eventDetails (apiMonitoringStatus active)

**Test ID**: ***api_status-3***

**Description**:

  This test case will check if an invoker subscribed to events **SERVICE_API_AVAILABLE** and **SERVICE_API_UNAVAILABLE**, with only ***apiStatusMonitoring*** active, receive SERVICE_API_AVAILABLE in mockserver when api is published by a provider, not containing eventDetails, and the same when api is unpublished.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered with 2 aefs.
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:
  1. Register Invoker and Onboard Invoker at CCF.
  2. Register Provider at CCF with 2 aefs.
  3. Subscribe to **SERVICE_API_AVAILABLE** and **SERVICE_API_UNAVAILABLE**. ***apiStatusMonitoring*** **active** at supported features (binary 1000-> string **8**)
  4. Publish Service API at CCF:
     1. Supported Features with apiStatusMonitoring flag inactive (binary 0 0000 0000 -> string **000**)
     2. This API not includes "API Status" information at **service API Description**.
  5. Discover Service APIs by Invoker
     1. includes filter by query parameter **aef-id**
  6. Provider remove published API.

**Information of Test**:

  1. Perform [Invoker Onboarding]
  2. Perform [Provider Registration] with 2 aefs
  3. Event Subscription to SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE of provider previously registered:
       1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
       2. body [event subscription request body] with:
          1. events: **['SERVICE_API_AVAILABLE','SERVICE_API_UNAVAILABLE']**
          2. supportedFeatures: binary 1000 -> string **8**
       3. Use **Invoker Certificate**
  4. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with **service_1** and **service_2** apiNames and realted with aefId1 and aefId2.
       * supportedFeatures **000**
       * 2 profiles, one with each aef.
     * Use **APF Certificate**
  5. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**
  6. Remove published Service API:
     * Send **DELETE** to resource URL **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis/{SERVICE_API_ID}**
     * Use **APF Certificate**

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**
  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  3. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
        * 2 profiles with:
          * resourceName resource_1 and aefId1
          * resourceName resource_2 and aefId2
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response without **"apiStatus"** parameter.
  4. Response to Discover Request By Invoker:
     1. **200 OK** response.
     2. Response body must follow **DiscoveredAPIs** data structure:
        * Check if DiscoveredAPIs contains the API Published previously
          * Check if **NOT** contains the **apiStatus** keys
  5. Response to Remove published Service API at CCF:
     1. **204 No Content**
  6. Mock Server received messages must accomplish:
     1. **Two Events have been received**.
     2. Validate received events follow **EventNotification** data structure, with **apiIds** in **eventDetail** parameter.
        1. One should be **SERVICE_API_AVAILABLE** apiId of published API without **eventDetails**.
        2. The other one must be **SERVICE_API_UNAVAILABLE** apiId of published API without **eventDetails**.


## -------------------------------------


## Test Case 12: Update published API without apiStatus and apiStatusMonitoring inactive

**Test ID**: ***api_status-12***

**Description**:

  This test case will check if an invoker subscribed to events **SERVICE_API_AVAILABLE**, **SERVICE_API_UNAVAILABLE** and **SERVICE_API_UPDATE** with ***apiStatusMonitoring*** and **Enhanced_event_report** active, receive SERVICE_API_AVAILABLE in mockserver when api is published by a provider, containing eventDetails, and SERVICE_API_UPDATE after update apiStatus to not present.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered with 2 aefs.
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:
  1. Register Invoker and Onboard Invoker at CCF.
  2. Register Provider at CCF with 2 aefs.
  3. Subscribe to **SERVICE_API_AVAILABLE**, **SERVICE_API_UNAVAILABLE** and **SERVICE_API_UPDATE**. **apiStatusMonitoring** and **Enhanced_event_report** **active** at supported features (binary 1100-> string **C**)
  4. Publish Service API at CCF:
     1. Supported Features with apiStatusMonitoring flag active (binary 0 0010 0000 -> string **020**)
     2. This API includes "API Status" information at **service API Description** with only aefId1.
  5. Discover Service APIs by Invoker
     1. includes filter by query parameter **aef-id**
  6. Update Published API:
     1. apiStatus Not present
     2. aipStatusMonitoring feature not active (binary 0 0000 0000 -> string **0**)

**Information of Test**:

  1. Perform [Invoker Onboarding]
  2. Perform [Provider Registration] with 2 aefs
  3. Event Subscription to SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE of provider previously registered:
       1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
       2. body [event subscription request body] with:
          1. events: **['SERVICE_API_AVAILABLE','SERVICE_API_UNAVAILABLE']**
          2. supportedFeatures: binary 1100 -> string **C**
       3. Use **Invoker Certificate**
  4. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with **service_1** and **service_2** apiNames and realted with aefId1 and aefId2.
       * supportedFeatures **020**
       * 2 profiles, one with each aef.
       * apiStatus with aefId1 inside array
     * Use **APF Certificate**
  5. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**
  6. Update published Service API:
     * Send **PUT** to resource URL **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis/{SERVICE_API_ID}**
     * Use **APF Certificate**
     * body [service api description] with **service_1** and **service_2** apiNames and realted with aefId1 and aefId2.
       * supportedFeatures **0**
       * 2 profiles, one with each aef.
       * apiStatus not present.

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**
  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  3. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
        * 2 profiles with:
          * resourceName resource_1 and aefId1
          * resourceName resource_2 and aefId2
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response without **"apiStatus"** parameter.
  4. Response to Discover Request By Invoker:
     1. **200 OK** response.
     2. Response body must follow **DiscoveredAPIs** data structure:
        * Check if DiscoveredAPIs contains the API Published previously
          * Check if contains the **apiStatus** with aefId1
  5. Response to Update published Service API at CCF:
     1. **200 OK**
     2. Store response with updated serviceAPIDescription.
  6. Mock Server received messages must accomplish:
     1. **Two Events have been received**.
     2. Validate received events follow **EventNotification** data structure, with **apiIds** in **eventDetail** parameter.
        1. One should be **SERVICE_API_AVAILABLE** apiId of published API with **eventDetails** with apiIds and serviceAPIDescription.
        2. The other one must be **SERVICE_API_UPDATE** apiId published API with **eventDetails** containing serviceAPIDescription updated.

## Test Case 13: Update published API with apiStatus empty and apiStatusMonitoring inactive

**Test ID**: ***api_status-13***

**Description**:

  This test case will check if an invoker subscribed to events **SERVICE_API_AVAILABLE**, **SERVICE_API_UNAVAILABLE** and **SERVICE_API_UPDATE** with ***apiStatusMonitoring*** and **Enhanced_event_report** active, receive SERVICE_API_AVAILABLE in mockserver when api is published by a provider, containing eventDetails, and SERVICE_API_UPDATE after update apiStatus to empty aefIds array qith **ApiStatusMonitoring inactive.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered with 2 aefs.
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:
  1. Register Invoker and Onboard Invoker at CCF.
  2. Register Provider at CCF with 2 aefs.
  3. Subscribe to **SERVICE_API_AVAILABLE**, **SERVICE_API_UNAVAILABLE** and **SERVICE_API_UPDATE**. **apiStatusMonitoring** and **Enhanced_event_report** **active** at supported features (binary 1100-> string **C**)
  4. Publish Service API at CCF:
     1. Supported Features with apiStatusMonitoring flag active (binary 0 0010 0000 -> string **020**)
     2. This API includes "API Status" information at **service API Description** with only aefId1.
  5. Discover Service APIs by Invoker
     1. includes filter by query parameter **aef-id**
  6. Update Published API:
     1. apiStatus present with empty aefIds array.
     2. aipStatusMonitoring feature not active (binary 0 0000 0000 -> string **0**)

**Information of Test**:

  1. Perform [Invoker Onboarding]
  2. Perform [Provider Registration] with 2 aefs
  3. Event Subscription to SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE of provider previously registered:
       1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
       2. body [event subscription request body] with:
          1. events: **['SERVICE_API_AVAILABLE','SERVICE_API_UNAVAILABLE']**
          2. supportedFeatures: binary 1100 -> string **C**
       3. Use **Invoker Certificate**
  4. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with **service_1** and **service_2** apiNames and realted with aefId1 and aefId2.
       * supportedFeatures **020**
       * 2 profiles, one with each aef.
       * apiStatus with aefId1 inside array
     * Use **APF Certificate**
  5. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**
  6. Update published Service API:
     * Send **PUT** to resource URL **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis/{SERVICE_API_ID}**
     * Use **APF Certificate**
     * body [service api description] with **service_1** and **service_2** apiNames and realted with aefId1 and aefId2.
       * supportedFeatures **0**
       * 2 profiles, one with each aef.
       * apiStatus not present.

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**
  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  3. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
        * 2 profiles with:
          * resourceName resource_1 and aefId1
          * resourceName resource_2 and aefId2
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response without **"apiStatus"** parameter.
  4. Response to Discover Request By Invoker:
     1. **200 OK** response.
     2. Response body must follow **DiscoveredAPIs** data structure:
        * Check if DiscoveredAPIs contains the API Published previously
          * Check if contains the **apiStatus** with aefId1
  5. Response to Update published Service API at CCF:
     1. **200 OK**
     2. Store response with updated serviceAPIDescription.
  6. Mock Server received messages must accomplish:
     1. **Two Events have been received**.
     2. Validate received events follow **EventNotification** data structure, with **apiIds** in **eventDetail** parameter.
        1. One should be **SERVICE_API_AVAILABLE** apiId of published API with **eventDetails** with apiIds and serviceAPIDescription.
        2. The other one must be **SERVICE_API_UPDATE** apiId published API with **eventDetails** containing serviceAPIDescription updated.


## --------------------

## Test Case 17: Patch published (apiStatusMonitoring active) API with apiStatus only aefId2

**Test ID**: ***api_status-17***

**Description**:

  This test case will check if an invoker subscribed to events **SERVICE_API_AVAILABLE**, **SERVICE_API_UNAVAILABLE** and **SERVICE_API_UPDATE** with ***apiStatusMonitoring*** and **Enhanced_event_report** active, receive SERVICE_API_AVAILABLE in mockserver when api is published by a provider (with apiStatusMonitoring active), containing eventDetails, and SERVICE_API_UPDATE after patch with apfId2 in apiStatus array.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered with 2 aefs.
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:
  1. Register Invoker and Onboard Invoker at CCF.
  2. Register Provider at CCF with 2 aefs.
  3. Subscribe to **SERVICE_API_AVAILABLE**, **SERVICE_API_UNAVAILABLE** and **SERVICE_API_UPDATE**. **apiStatusMonitoring** and **Enhanced_event_report** **active** at supported features (binary 1100-> string **C**)
  4. Publish Service API at CCF:
     1. Supported Features with apiStatusMonitoring flag active (binary 0 0010 0000 -> string **020**)
     2. This API includes "API Status" information at **service API Description** with only aefId1.
  5. Discover Service APIs by Invoker
     1. includes filter by query parameter **aef-id**
  6. Patch Published API:
     1. apiStatus present with aefId2 in array.

**Information of Test**:

  1. Perform [Invoker Onboarding]
  2. Perform [Provider Registration] with 2 aefs
  3. Event Subscription to SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE of provider previously registered:
       1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
       2. body [event subscription request body] with:
          1. events: **['SERVICE_API_AVAILABLE','SERVICE_API_UNAVAILABLE']**
          2. supportedFeatures: binary 1100 -> string **C**
       3. Use **Invoker Certificate**
  4. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with **service_1** and **service_2** apiNames and realted with aefId1 and aefId2.
       * supportedFeatures **020**
       * 2 profiles, one with each aef.
       * apiStatus with aefId1 inside array
     * Use **APF Certificate**
  5. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**
  6. Update published Service API:
     * Send **PATCH** to resource URL **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis/{SERVICE_API_ID}**
     * Use **APF Certificate**
     * body [service api description patch] and realted with aefId1 and aefId2.
       * apiStatus present with aefId2.

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**
  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  3. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
        * 2 profiles with:
          * resourceName resource_1 and aefId1
          * resourceName resource_2 and aefId2
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response without **"apiStatus"** parameter.
  4. Response to Discover Request By Invoker:
     1. **200 OK** response.
     2. Response body must follow **DiscoveredAPIs** data structure:
        * Check if DiscoveredAPIs contains the API Published previously
          * Check if contains the **apiStatus** with aefId1
  5. Response to Patch published Service API at CCF:
     1. **200 OK**
     2. Store response with updated serviceAPIDescription.
  6. Mock Server received messages must accomplish:
     1. **Two Events have been received**.
     2. Validate received events follow **EventNotification** data structure, with **apiIds** in **eventDetail** parameter.
        1. One should be **SERVICE_API_AVAILABLE** apiId of published API with **eventDetails** with apiIds and serviceAPIDescription.
        2. The other one must be **SERVICE_API_UPDATE** apiId published API with **eventDetails** containing serviceAPIDescription patched.



   [service api description]: ../api_publish_service/service_api_description_post_example.json  "Service API Description Request"
   [service api description patch]: ../api_publish_service/service_api_description_patch_example.json  "Service API Description Patch Request"
   [publisher register body]: ../api_publish_service/publisher_register_body.json  "Publish register Body"
   [invoker onboarding body]: ../api_invoker_management/invoker_details_post_example.json  "API Invoker Request"
   [provider request body]: ../api_provider_management/provider_details_post_example.json  "API Provider Enrolment Request"
   [provider request patch body]: ../api_provider_management/provider_details_enrolment_details_patch_example.json  "API Provider Enrolment Patch Request"

   [invoker onboarding]: ../common_operations/README.md#onboard-an-invoker "Invoker Onboarding"
   [provider registration]: ../common_operations/README.md#register-a-provider "Provider Registration"
   [event subscription request body]: ../api_events_service/event_subscription.json  "Event Subscription Request"
