# CAPIF Dynamic Configuration

## Overview
CAPIF supports dynamic configuration management, enabling modifications without requiring redeployment. This is achieved by storing configurations in MongoDB collections for both CAPIF and Register services, allowing CAPIF to retrieve and apply configuration changes dynamically.

This new approach provides:
  
* **Real-time configuration updates**: Modify parameters on the fly.
* **Extensibility**: Add new parameters or sections dynamically.
* **Improved flexibility**: Reduce static configuration dependencies.

## CAPIF Configuration

In the CAPIF MongoDB instance, it is included a collection of the configuration.

```json
capif_configuration: {
  "config_name": "default",
  "version": "1.0",
  "description": "Default CAPIF Configuration",
  "settings": {
    "certificates_expiry": {
      ttl_superadmin_cert: "4300h",
      ttl_invoker_cert: "4300h",
      ttl_provider_cert: "4300h",
    },
    "security_method_priority": {
      oauth: 1,
      pki: 2,
      psk: 3
    },
    "acl_policy_settings": {
      allowed_total_invocations: 5,
      allowed_invocations_per_second: 10,
      allowed_invocation_time_range_days: 365
    }
  }
}
```


## Register Configuration

Similarly, the Register service includes a dynamic configuration stored in its MongoDB instance:

```json
capif_configuration: {
  "config_name": "default",
  "version": "1.0",
  "description": "Default Register Configuration",
  "settings": {
    "certificates_expiry": {
      ttl_superadmin_cert: "4300h",
    }
  }
}
```

## Configuration Management Endpoints

Both CAPIF and the register configuration are managed via API, the general configuration of CAPIF from the Helper service and the register configuration from the register. In both services these endpoints enable:

1. Retrieving the current configuration – View the existing settings stored in MongoDB.

2. Modifying configuration parameters – Update specific values dynamically.

3. Adding new configuration settings – Introduce additional parameters within existing sections or create entirely new sections in the configuration.

For more details, you can check the API documentation of the Helper and Register services:

- [Helper Service API Documentation](../helper/swagger.md)
- [Register Service API Documentation](../register/swagger.md)




