# Vendor Extensibility
This is a mechanism for the APIs to re-use, extend their functionalities and data models and engage with third-party API frameworks. 

Is defined on 3GPP TS 29.122 and 29.500 and is tightly connected with “supported-features” and feature negotiation

## Supported Features in Publish API:
![Publish Supported Features](../images/vendor-ext/publish_supported_features.png)

## Types of vendor extensions

**Data models**

* Extend the information element with vendor specific fields
### Fields have specific naming schemes:
* Using the 6-digit IANA-assigned enterprise code:



```
  "vendorSpecific-010415": {
        ...
        }
```

* Using domain name:


```
"vendorSpecific-3gpp.org": {
        ...
        }
```

* Using URN:


```
"vendorSpecific-urn:3gpp:example": {
        ...
        }
```

## Discover Query Parameters

* Provisioning of vendor-specific query parameters to support additional vendor-specific filtering criteria
### A vendor-specific query parameter shall be encoded as follows:
    
* query parameter name: 


```
"vend-spec-<query parameter name>”
```

* query parameter value encoded as JSON object:
    * "target" 
    * "value"

**Example:**
```
GET {apiRoot}/3gpp-monitoring-event/v1/{scsAsId}/subscriptions?vend-spec-max-reports={"target": "/maximumNumberOfReports", value: "6"} 
```


[OCF Web]: https://ocf.etsi.org/ "OCF Web"
[OCF Documentation]: https://ocf.etsi.org/documentation/ "OCF Documentation"
