# Test Plan for Event Filter Feature
At this documentation you will have all information and related files and examples of test plan for this feature.


## Test Case 1: Invoker subscribed to SERVICE_API_AVAILABLE, SERVICE_API_UNAVAILABLE and SERVICE_API_UPDATE events filtered by apiIds

**Test ID**: ***event_filter-1***
**Additional Tags**: ***mockserver***

**Description**:

   This test case will check an invoker can subscribe to SERVICE_API events and filter them by apiId.


**Pre-Conditions**:

   * Invoker is previously registered and onboarded.
   * Two providers registered and with APIs published.
   * **Mock Server is up and running to receive requests.**
   * **Mock Server is clean.**


**Execution Steps**:

1. Register and onboard ***Invoker***
2. Register ***Provider 1*** and publish ***service_1*** api:
      1. Setup provider with Two AEFs.
      2. Publish ***service_1*** with:
         1. Two AEFs. (aef_id_1 and aef_id_2)
         2. apiStatus empty list.
         3. supportedFeatures 020.
3. Register ***Provider 2*** and publish ***service_2*** api:
      1. Publish ***service_2*** with:
         1. apiStatus with AEF Id (aef2_id_1)
         2. supportedFeatures 020
4. Discover APIs by Invoker:
      1. filter by aef_id_1
      2. Only one api will be obtained, store apiId at api_id.
5. Subscribe to events:
      1. Events: ***SERVICE_API_AVAILABLE, SERVICE_API_UNAVAILABLE, SERVICE_API_UPDATE.***
      2. EventFilter: ***[apiId], [apiId], [apiId].***
      3. supportedFeatures: ***C***
6. Update service_1 api:
      1. apiStatus with ***aefIds*** present on ***Provider 1***.
      2. SupportedFeatures set to ***20***
7. Remove Provider 1
8. Remove Provider 2

**Expected Results**:

Mock Server received messages must accomplish:

1. **Three Events have been received**.
2. Validate received events follow **EventNotification** data structure, with:
      1. **SERVICE_API_AVAILABLE**:
         1. EventDetail include serviceAPIDescriptions with same Service API description Modified with apiStatus containing aefIds of provider 1
      2. **SERVICE_API_UPDATE**:
         1. EventDetail include serviceAPIDescriptions with same Service API description Modified with apiStatus containing aefIds of provider 1
      3. **SERVICE_API_UNAVAILABLE**
         1. EventDetail include serviceAPIDescriptions with same Service API description Modified with apiStatus containing aefIds of provider 1

---
## Test Case 2: Invoker subscribed to SERVICE_API_AVAILABLE, SERVICE_API_UNAVAILABLE and SERVICE_API_UPDATE events filtered by not valid filters

**Test ID**: ***event_filter-2***
**Additional Tags**: ***smoke***

**Description**:

   This test case will check all error response related with wrong filtering options when invoker subscribes to SERVICE_API events.

**Pre-Conditions**:

   * Invoker is previously registered and onboarded.
   * Two providers registered and with APIs published.

**Execution Steps**:

1. Register and onboard ***Invoker***
2. Register ***Provider 1*** and publish ***service_1*** api:
      1. Setup provider with Two AEFs.
      2. Publish ***service_1*** with:
         1. Two AEFs. (aef_id_1 and aef_id_2)
         2. apiStatus empty list.
         3. supportedFeatures 020.
3. Register ***Provider 2*** and publish ***service_2*** api:
      1. Publish ***service_2*** with:
         1. apiStatus with AEF Id (aef2_id_1)
         2. supportedFeatures 020
4. Discover APIs by Invoker:
      1. filter by aef_id_1
      2. Only one api will be obtained, store apiId at api_id.
5. Subscribe to events:
      1. Events: ***SERVICE_API_AVAILABLE, SERVICE_API_UNAVAILABLE, SERVICE_API_UPDATE.***
      2. EventFilter: ***[aefIds], [empty], [empty].***
      3. supportedFeatures: ***C***
6. Subscribe to events:
      1. Events: ***SERVICE_API_AVAILABLE, SERVICE_API_UNAVAILABLE, SERVICE_API_UPDATE.***
      2. EventFilter: ***[empty], [aefIds], [empty].***
      3. supportedFeatures: ***C***
7. Subscribe to events:
      1. Events: ***SERVICE_API_AVAILABLE, SERVICE_API_UNAVAILABLE, SERVICE_API_UPDATE.***
      2. EventFilter: ***[empty], [empty], [aefIds].***
      3. supportedFeatures: ***C***
8. Subscribe to events:
      1. Events: ***SERVICE_API_AVAILABLE, SERVICE_API_UNAVAILABLE, SERVICE_API_UPDATE.***
      2. EventFilter: ***[empty], [empty], [apiInvokerIds].***
      3. supportedFeatures: ***C***

**Expected Results**:

We will receive one error after each Event subscription:

1. Response to first subscription:
      1. ***400 Bad Request***
      2. ProblemDetails Body with:
         1. title: ***Bad Request***
         2. status: ***400***
         3. detail: ***Bad Param***
         4. cause: ***Invalid eventFilter for event SERVICE_API_AVAILABLE***
         5. invalidParams: ***[{ param:eventFilter, reason: The eventFilter aef_ids for event SERVICE_API_AVAILABLE are not applicable }]***
2. Response to first subscription:
      1. ***400 Bad Request***
      2. ProblemDetails Body with:
         1. title: ***Bad Request***
         2. status: ***400***
         3. detail: ***Bad Param***
         4. cause: ***Invalid eventFilter for event SERVICE_API_UNAVAILABLE***
         5. invalidParams: ***[{ param:eventFilter, reason: The eventFilter aef_ids for event SERVICE_API_UNAVAILABLE are not applicable }]***
3. Response to first subscription:
      1. ***400 Bad Request***
      2. ProblemDetails Body with:
         1. title: ***Bad Request***
         2. status: ***400***
         3. detail: ***Bad Param***
         4. cause: ***Invalid eventFilter for event SERVICE_API_UPDATE***
         5. invalidParams: ***[{ param:eventFilter, reason: The eventFilter aef_ids for event SERVICE_API_UPDATE are not applicable }]***
4. Response to first subscription:
      1. ***400 Bad Request***
      2. ProblemDetails Body with:
         1. title: ***Bad Request***
         2. status: ***400***
         3. detail: ***Bad Param***
         4. cause: ***Invalid eventFilter for event SERVICE_API_UPDATE***
         5. invalidParams: ***[{ param:eventFilter, reason: The eventFilter api_invoker_ids for event SERVICE_API_UPDATE are not applicable }]***

---
## Test Case 3: Provider subscribed to API_INVOKER_ONBOARDED, API_INVOKER_OFFBOARDED and API_INVOKER_UPDATED events filtered by invokerIds

**Test ID**: ***event_filter-3***
**Additional Tags**: ***mockserver***

**Description**:

   This test case will check subcription to all API_INVOKER events by one provider.

**Pre-Conditions**:

   * Provider is previously registered.
   * **Mock Server is up and running to receive requests.**
   * **Mock Server is clean.**

**Execution Steps**:

1. Register ***Provider 1***.
2. Subscribe to events:
      1. Events: ***API_INVOKER_ONBOARDED***
      2. EventFilter: ***No filter.***
      3. supportedFeatures: ***C***
3. Register and onboard ***Invoker 1***
4. Register and onboard ***Invoker 2***
5. Subscribe provider to events:
      1. Events: ***API_INVOKER_ONBOARDED, API_INVOKER_OFFBOARDED, API_INVOKER_UPDATED***
      2. EventFilter: ***[empty], [apiInvokerId1], [apiInvokerId2].***
      3. supportedFeatures: ***C***
6. Update Invoker 1:
      1. Setup new notificationDestination at invoker.
7. Update Invoker 2:
      1. Setup new notificationDestination at invoker.
8. Remove Invoker 1.
9. Remove Invoker 2.

**Expected Results**:

Mock Server received messages must accomplish:

1. **Four Events have been received**.
2. Validate received events follow **EventNotification** data structure, with:
      1. **API_INVOKER_ONBOARDED**:
         1. EventDetail include apiInvokerIds with apiInvokerId of provider 1
      2. **API_INVOKER_ONBOARDED**:
         1. EventDetail include apiInvokerIds with apiInvokerId of provider 2
      3. **API_INVOKER_UPDATED**:
         1. EventDetail include apiInvokerIds with apiInvokerId of provider 2
      4. **API_INVOKER_OFFBOARDED**
         1. EventDetail include apiInvokerIds with apiInvokerId of provider 1


---
## Test Case 4: Provider subscribed to API_INVOKER_ONBOARDED, API_INVOKER_OFFBOARDED and API_INVOKER_UPDATED events filtered by not valid filters

**Test ID**: ***event_filter-4***
**Additional Tags**: 

**Description**:

   This test will check API_INVOKER events subscription by Provider with not valid filters.

**Pre-Conditions**:

   * Provider is previously registered.

**Execution Steps**:

1. Register ***Provider 1***.
2. Register and onboard ***Invoker 1***
3. Register and onboard ***Invoker 2***
4. Subscribe provider to events:
      1. Subscription 1
      2. Events: ***API_INVOKER_ONBOARDED, API_INVOKER_OFFBOARDED, API_INVOKER_UPDATED***
      3. EventFilter: ***[aefIds], [empty], [empty].***
      4. supportedFeatures: ***C***
5. Subscribe provider to events:
      1. Subscription 2
      2. Events: ***API_INVOKER_ONBOARDED, API_INVOKER_OFFBOARDED, API_INVOKER_UPDATED***
      3. EventFilter: ***[empty], [aefIds], [empty].***
      4. supportedFeatures: ***C***
6. Subscribe provider to events:
      1. Subscription 3
      2. Events: ***API_INVOKER_ONBOARDED, API_INVOKER_OFFBOARDED, API_INVOKER_UPDATED***
      3. EventFilter: ***[empty], [empty], [aefIds].***
      4. supportedFeatures: ***C***
7. Subscribe provider to events:
      1. Subscription 4
      2. Events: ***API_INVOKER_ONBOARDED, API_INVOKER_OFFBOARDED, API_INVOKER_UPDATED***
      3. EventFilter: ***[empty], [empty], [apiIds].***
      4. supportedFeatures: ***C***

**Expected Results**:

1. Response to first subscription:
      1. ***400 Bad Request***
      2. ProblemDetails Body with:
         1. title: ***Bad Request***
         2. status: ***400***
         3. detail: ***Bad Param***
         4. cause: ***Invalid eventFilter for event API_INVOKER_ONBOARDED***
         5. invalidParams: ***[{ param:eventFilter, reason: The eventFilter aef_ids for event API_INVOKER_ONBOARDED are not applicable }]***
2. Response to second subscription:
      1. ***400 Bad Request***
      2. ProblemDetails Body with:
         1. title: ***Bad Request***
         2. status: ***400***
         3. detail: ***Bad Param***
         4. cause: ***Invalid eventFilter for event API_INVOKER_OFFBOARDED***
         5. invalidParams: ***[{ param:eventFilter, reason: The eventFilter aef_ids for event API_INVOKER_OFFBOARDED are not applicable }]***
3. Response to third subscription:
      1. ***400 Bad Request***
      2. ProblemDetails Body with:
         1. title: ***Bad Request***
         2. status: ***400***
         3. detail: ***Bad Param***
         4. cause: ***Invalid eventFilter for event API_INVOKER_UPDATED***
         5. invalidParams: ***[{ param:eventFilter, reason: The eventFilter aef_ids for event API_INVOKER_UPDATED are not applicable }]***
4. Response to fourth subscription:
      1. ***400 Bad Request***
      2. ProblemDetails Body with:
         1. title: ***Bad Request***
         2. status: ***400***
         3. detail: ***Bad Param***
         4. cause: ***Invalid eventFilter for event API_INVOKER_UPDATED***
         5. invalidParams: ***[{ param:eventFilter, reason: The eventFilter api_ids for event API_INVOKER_UPDATED are not applicable }]***

---
## Test Case 5: Provider subscribed to ACCESS_CONTROL_POLICY_UPDATE event filtered by only apiId, only invokerId and both

**Test ID**: ***event_filter-5***
**Additional Tags**: ***smoke***, ***mockserver***

**Description**:

   This test case will check subcription to  ACCESS_CONTROL_POLICY_UPDATE event by one provider.

**Pre-Conditions**:

   * Two Providers are previously registered and published APIs
   * Two invoker are previously registered.
   * **Mock Server is up and running to receive requests.**
   * **Mock Server is clean.**

**Execution Steps**:


1. Register ***Provider 1*** and publish ***service_1*** api:
      * Store apiId1
2. Register ***Provider 2*** and publish ***service_2*** api:
      * Store apiId2
3. Register and onboard ***Invoker 1***
      * apiInvokerId1
4. Register and onboard ***Invoker 2***
      * apiInvokerId2
6. Subscribe to events:
      1. Subscription1
      2. Events: ***ACCESS_CONTROL_POLICY_UPDATE***
      3. EventFilter: ***[apiId1].***
      4. supportedFeatures: ***C***
7. Subscribe to events:
      1. Subscription2
      2. Events: ***ACCESS_CONTROL_POLICY_UPDATE***
      3. EventFilter: ***[apiInvokerId1].***
      4. supportedFeatures: ***C***
7. Subscribe to events:
      1. Subscription3
      2. Events: ***ACCESS_CONTROL_POLICY_UPDATE***
      3. EventFilter: ***[apiInvokerId2] and [apiId2].***
      4. supportedFeatures: ***C***
8. Create Security Context Between Invoker 1 and provider 1 exposed API.
      1. Store acl_provider_1
9. Create Security Context Between Invoker 2 and provider 1 exposed API.
      1. Store acl_provider_1 (array will contain 2 values)
10. Create Security Context Between Invoker 1 and provider 2 exposed API.
      1. Store acl_provider_2 (array will contain 2 values)
11. Create Security Context Between Invoker 2 and provider 2 exposed API.
      1. Store acl_provider_2 (array will contain 2 values)

**Expected Results**:

1. **Eight Events have been received** for 3 different subscriptions.
2. Validate received events follow **EventNotification** data structure
3. **Subcription 1**:
      1. **ACCESS_CONTROL_POLICY_UPDATE**:
         1. EventDetail include accCtrlPolList with apiId1 and apiInvokerPolicies with Security Context between invoker 1 and provider 1 (acl_provider_1[0])
      2. **ACCESS_CONTROL_POLICY_UPDATE**:
         1. EventDetail include accCtrlPolList with apiId1 and apiInvokerPolicies with Security Context between invoker 2 and provider 1 (acl_provider_1[1])
      3. **ACCESS_CONTROL_POLICY_UPDATE**:
         1. EventDetail include accCtrlPolList with apiId2 and apiInvokerPolicies with Security Context between invoker 1 and provider 2 (acl_provider_2[0])
      4. **ACCESS_CONTROL_POLICY_UPDATE**:
         1. EventDetail include accCtrlPolList with apiId1 and apiInvokerPolicies with Security Context between invoker 2 and provider 2 (acl_provider_2[1])
4. **Subcription 2**:
      1. **ACCESS_CONTROL_POLICY_UPDATE**:
         1. EventDetail include accCtrlPolList with apiId1 and apiInvokerPolicies with Security Context between invoker 1 and provider 1 (acl_provider_1[0])
      2. **ACCESS_CONTROL_POLICY_UPDATE**:
         1. EventDetail include accCtrlPolList with apiId1 and apiInvokerPolicies with Security Context between invoker 1 and provider 1 (acl_provider_1[0])
      3. **ACCESS_CONTROL_POLICY_UPDATE**:
         1. EventDetail include accCtrlPolList with apiId2 and apiInvokerPolicies with Security Context between invoker 1 and provider 2 (acl_provider_2[0])
5. **Subcription 3**:
      1. **ACCESS_CONTROL_POLICY_UPDATE**:
         1. EventDetail include accCtrlPolList with apiId2 and apiInvokerPolicies with Security Context between invoker 2 and provider 2 (acl_provider_2[1])

---
## Test Case 6: Provider subscribed to ACCESS_CONTROL_POLICY_UPDATE event filtered by aefId

**Test ID**: ***event_filter-6***
**Additional Tags**:

**Description**:

   This test will check ACCESS_CONTROL_POLICY_UPDATE event subscription by Provider with not valid filters.

**Pre-Conditions**:

   * One Provider is previously registered.

**Execution Steps**:

1. Register ***Provider 1***.
2. Subscribe to events:
      1. Subscription1
      2. Events: ***ACCESS_CONTROL_POLICY_UPDATE***
      3. EventFilter: ***[aef_ids].***
      4. supportedFeatures: ***C***

**Expected Results**:

1. Response to subscription:
      1. ***400 Bad Request***
      2. ProblemDetails Body with:
         1. title: ***Bad Request***
         2. status: ***400***
         3. detail: ***Bad Param***
         4. cause: ***Invalid eventFilter for event ACCESS_CONTROL_POLICY_UPDATE***
         5. invalidParams: ***[{ param:eventFilter, reason: The eventFilter aef_ids for event ACCESS_CONTROL_POLICY_UPDATE are not applicable }]***

---
## Test Case 7: Provider subscribed to SERVICE_API_INVOCATION_SUCCESS and SERVICE_API_INVOCATION_FAILURE filtered by apiId, invokerId, aefId and all of them

**Test ID**: ***event_filter-7***
**Additional Tags**: **smoke**, **mockserver**

**Description**:

   This test will check all possible filters options allowed for SERVICE_API_INVOCATION_SUCCESS and SERVICE_API_INVOCATION_FAILURE.

**Pre-Conditions**:

   * Two Providers are previously registered and published APIs
   * Two invoker are previously registered.
   * **Mock Server is up and running to receive requests.**
   * **Mock Server is clean.**

**Execution Steps**:

1. Register ***Provider 1*** and publish ***service_1*** api:
      * Store apiId1
      * Store aefId1
2. Register ***Provider 2*** and publish ***service_2*** api:
      * Store apiId2
      * Store aefId2
3. Register and onboard ***Invoker 1***
      * apiInvokerId1
4. Register and onboard ***Invoker 2***
      * apiInvokerId2
6. Subscribe provider 1 to events:
      1. Subscription 1
      2. Events: ***SERVICE_API_INVOCATION_SUCCESS, SERVICE_API_INVOCATION_FAILURE.***
      3. EventFilter: ***[apiId1], [apiId1].***
      4. supportedFeatures: ***C***
7. Subscribe provider 1 to events:
      1. Subscription 2
      2. Events: ***SERVICE_API_INVOCATION_SUCCESS, SERVICE_API_INVOCATION_FAILURE.***
      3. EventFilter: ***[apiId1], [apiId1].***
      4. supportedFeatures: ***C***
8. Subscribe provider 1 to events:
      1. Subscription 3
      2. Events: ***SERVICE_API_INVOCATION_SUCCESS, SERVICE_API_INVOCATION_FAILURE.***
      3. EventFilter: ***[apiId1], [apiId1].***
      4. supportedFeatures: ***C***
9.  Subscribe provider 1 to events:
      1. Subscription 4
      2. Events: ***SERVICE_API_INVOCATION_SUCCESS, SERVICE_API_INVOCATION_FAILURE.***
      3. EventFilter: ***[apiId1], [apiId1].***
      4. supportedFeatures: ***C***
10. Subscribe provider 1 to events:
      1. Subscription 5
      2. Events: ***SERVICE_API_INVOCATION_SUCCESS, SERVICE_API_INVOCATION_FAILURE.***
      3. EventFilter: ***[apiId1], [apiId1].***
      4. supportedFeatures: ***C***
11. Subscribe provider 1 to events:
      1. Subscription 6
      2. Events: ***SERVICE_API_INVOCATION_SUCCESS, SERVICE_API_INVOCATION_FAILURE.***
      3. EventFilter: ***[apiId1], [apiId1].***
      4. supportedFeatures: ***C***
12. Subscribe provider 1 to events:
      1.  Subscription 7
      2. Events: ***SERVICE_API_INVOCATION_SUCCESS, SERVICE_API_INVOCATION_FAILURE.***
      3. EventFilter: ***[apiId1], [apiId1].***
      4. supportedFeatures: ***C***
13. Send Log entry by provider1:
      1. apiNames: [service_1]
      2. apiIds: [apiId1]
      3. aefId: aefId1
      4. apiInvokerId: apiInvokerId1
      5. results: [200, 400]
      6. Store body to **request_body_log_1**
14. Send Log entry by provider2:
      1. apiNames: [service_2]
      2. apiIds: [apiId2]
      3. aefId: aefId2
      4. apiInvokerId: apiInvokerId1
      5. results: [200]
      6. Store body to **request_body_log_2**
15. Send Log entry by provider2:
      1. apiNames: [service_2]
      2. apiIds: [apiId2]
      3. aefId: aefId2
      4. apiInvokerId: apiInvokerId2
      5. results: [200]
      6. Store body to **request_body_log_3**
16. Send Log entry by provider1:
      1. apiNames: [service_1]
      2. apiIds: [apiId1]
      3. aefId: aefId1
      4. apiInvokerId: apiInvokerId2
      5. results: [400]
      6. Store body to **request_body_log_4**

**Expected Results**:

1. **Thirteen Events have been received** for 7 different subscriptions.
2. Validate received events follow **EventNotification** data structure
3. **Subcription 1**:
      1. **SERVICE_API_INVOCATION_SUCCESS**:
         1. EventDetail include invocationLogs with **request_body_log_1**
      2. **SERVICE_API_INVOCATION_FAILURE**:
         1. EventDetail include invocationLogs with **request_body_log_1**
      3. **SERVICE_API_INVOCATION_FAILURE**:
         1. EventDetail include invocationLogs with **request_body_log_4**
4. **Subcription 2**:
      1. **SERVICE_API_INVOCATION_SUCCESS**:
         1. EventDetail include invocationLogs with **request_body_log_2**
      2. **SERVICE_API_INVOCATION_SUCCESS**:
         1. EventDetail include invocationLogs with **request_body_log_3**
5. **Subcription 3**:
      1. **SERVICE_API_INVOCATION_SUCCESS**:
         1. EventDetail include invocationLogs with **request_body_log_1**
      2. **SERVICE_API_INVOCATION_SUCCESS**:
         1. EventDetail include invocationLogs with **request_body_log_1**
      3. **SERVICE_API_INVOCATION_SUCCESS**:
         1. EventDetail include invocationLogs with **request_body_log_2**
6. **Subcription 4**:
      1. **SERVICE_API_INVOCATION_SUCCESS**:
         1. EventDetail include invocationLogs with **request_body_log_2**
      2. **SERVICE_API_INVOCATION_SUCCESS**:
         1. EventDetail include invocationLogs with **request_body_log_3**
7. **Subcription 5**:
      1. **SERVICE_API_INVOCATION_SUCCESS**:
         1. EventDetail include invocationLogs with **request_body_log_3**
8. **Subcription 6**:
      1. **SERVICE_API_INVOCATION_FAILURE**:
         1. EventDetail include invocationLogs with **request_body_log_4**
9. **Subcription 7**:
      1. **SERVICE_API_INVOCATION_SUCCESS**:
         1. EventDetail include invocationLogs with **request_body_log_3**

---
## Test Case 8: Event Filter present with Enhanced_event_report feature not active.

**Test ID**: ***event_filter-8***
**Additional Tags**: **smoke**

**Description**:

   This test will check event subscription by Invoker with eventFilter attribute but without Enhanced_event_report feature active.

**Pre-Conditions**:

   * Invoker is previously registered and onboarded.

**Execution Steps**:

1. Register and onboard ***Invoker***
2. Subscribe to events:
      2. Events: ***SERVICE_API_AVAILABLE, SERVICE_API_UNAVAILABLE, SERVICE_API_UPDATE***
      3. EventFilter: ***[empty], [empty], [empty].***
      4. supportedFeatures: ***0***

**Expected Results**:

1. Response to subscription:
      1. ***400 Bad Request***
      2. ProblemDetails Body with:
         1. title: ***Bad Request***
         2. status: ***400***
         3. detail: ***Bad Param***
         4. cause: ***Event filters provided but EnhancedEventReport is not enabled***
         5. invalidParams: ***[{ param:eventFilter, reason: EnhancedEventReport is not enabled }]***

---




   [service api description]: ../api_publish_service/service_api_description_post_example.json  "Service API Description Request"
   [service api description patch]: ../api_publish_service/service_api_description_patch_example.json  "Service API Description Patch Request"
   [publisher register body]: ../api_publish_service/publisher_register_body.json  "Publish register Body"
   [invoker onboarding body]: ../api_invoker_management/invoker_details_post_example.json  "API Invoker Request"
   [provider request body]: ../api_provider_management/provider_details_post_example.json  "API Provider Enrolment Request"
   [provider request patch body]: ../api_provider_management/provider_details_enrolment_details_patch_example.json  "API Provider Enrolment Patch Request"

   [invoker onboarding]: ../common_operations/README.md#onboard-an-invoker "Invoker Onboarding"
   [provider registration]: ../common_operations/README.md#register-a-provider "Provider Registration"
   [event subscription request body]: ../api_events_service/event_subscription.json  "Event Subscription Request"
