# API Status Feature

The API Status feature, introduced in the 3GPP Common API Framework (CAPIF) technical specifications starting from Release 17, offers significant enhancements for operators and developers.

This feature in OpenCAPIF provides real-time insights into the operational status of APIs, enabling stakeholders to quickly determine whether an API is functioning as expected. By improving API availability tracking, it helps users make more informed decisions about integration and usage.

## How it works
This new functionality is found in two CAPIF services, the publish service and the events service.

### Publish service
The API Status in the publish service allows providers to show in which AEFs the published API is available.

In order to use the API Status, it is necessary to have *apiStatusMonitoring* enabled in supportedFeatures when publishing an API. With this enabled, we can use the publication's apiStatus, which is composed of a list of AEF identifiers in which the API is available.

This gives us 4 options for displaying the status of an API:

- If the apiStatus contains a list of aefIds, the api will be **available** on all aefs in the list.
- If the apiStatus contains an empty list of aefIds it means that the API is **NOT available** in any AEF.
- If the apiStatus is not used, it is understood that the api is **available** in all AEFs of the aefProfiles.
- If the *apiStatusMonitoring* was not supported, the api would be **available** in all AEFs in the aefProfiles.

If *apiStatusMonitoring* is not supported and apiStatus is used to show API availability, a 400 error will be returned.

### Events service
The API Status within the Events service provides critical insights into the availability of subscribed services.

Both API Invokers and Providers can subscribe to the **SERVICE_API_AVAILABLE** and **SERVICE_API_UNAVAILABLE** events to receive timely notifications about the operational status of an API, whether it becomes available or unavailable.

Additionally, if the *enhanced_event_report* function is supported, the API description could be received as event details in the eventDetails field if *apiStatusMonitoring* is also enabled. This will make it easier for event subscribers to know if any changes have been made to the API, such as a change in API availability to other AEFs.


