from flask import Flask, jsonify, request
from flask_jwt_extended import jwt_required, JWTManager
from werkzeug import serving
from OpenSSL import crypto

app = Flask(__name__)

jwt_flask = JWTManager(app)


with open("Responses/cert_server.pem", "rb") as cert_file:
            cert= cert_file.read()

crtObj = crypto.load_certificate(crypto.FILETYPE_PEM, cert)
pubKeyObject = crtObj.get_pubkey()
pubKeyString = crypto.dump_publickey(crypto.FILETYPE_PEM,pubKeyObject)

app.config['JWT_ALGORITHM'] = 'RS256'
app.config['JWT_PUBLIC_KEY'] = pubKeyString


@app.route("/hello", methods=["POST"])
@jwt_required()
def hello():

    request_data = request.get_json()

    user_name = request_data['name']

    return jsonify(f"Hello: {user_name}, welcome to CAPIF.")

if __name__ == '__main__':
    serving.run_simple("0.0.0.0", 8088, app)
