## **Release 2.0.0**

### **New Features**

#### 3GPP CAPIF release 18

- Added new endpoints included in new release 18.
  - New logic for PATCH endpoints.
- New logic to support Vendor Extensibility
  - 9 new tests to check this logic.
- New logic to support API Status feature
- Supported Features now are mandatory for all POST Requests as is described on TS 29.222.
    - Possible Breaking change, all POST request now must include supported features attribute, default can me set to "0" to keep all features inactive.
    - Possible Breaking change on Events API, if you need eventDetails information on notification you must activate Enhanced Event Report on supported features.
- New 8 tests on Events API to check supported features support.


### **Technical Debt Solved**

#### **Issues**

- REDIS scheduled on start to allow receive notification since service is deployed.
- Problem removing service APIs published is provider register more than one APF.
- Superadmin problem deleting service API published through helper service if provider is not present.

#### Scripts upgraded

- New local scripts
- New remote scripts

### **Documentation**

#### New test included on documentation

- New 9 test on Vendor Extensibility test plan.
- New 8 tests on Events API test plan.
- Test plan updated with default supported features for all request set to "0" (all inactive by default).



--->>>>  must be included - New tests to check PATCH request

## **Release 1.0.0**

### **New Features**

#### Registration Flow improved

- Eliminated access from CAPIF to the Register user database when onboarding is performed.
- Isolation between CCF and Register services, interaction now is only by HTTPS requested between Register, CCF and Vault.
- Eliminated the "role" in user creation.
    - Now a user can be an invoker or a provider at the same time
- Administrator User:
    - New entity in charge of registering and managing users of the register service.
- UUID to identify users.
    - When you create a user, a uuid is associated with it
    - The uuid will be contained in the token requested by the user and will be used to relate invokers and providers with users.
- Endpoints changed and created:
    - Administrator endpoints:
        - /createUser: /register endpoint changed to createUser. Used to register new users.
        - /deleteUser: /remove endpoint changed to this. Used to delete users and all the entities they had created.
        - /login: Allows administrator to log in to obtain the necessary tokens for their requests.
        - /refresh: Retrieve new access token token.
        - /getUsers: Returns the list with all registered users.
    - Customer User:
        - /getauth now also returns the urls needed to use CAPIF, used by customer.
- Security improvements:
    - /login uses basic auth with administrator credentials.
    - /getauth uses basic auth with customer user credentials.
    - Other requests use the administrator access token obtained from login.

- Current fields on user creation by administrator:
```
required_fields = {
    "username": str,
    "password": str,
    "enterprise": str,
    "country": str,
    "email": str,
    "purpose": str
}

optional_fields = {
    "phone_number": str,
    "company_web": str,
    "description": str
}
```

- Test plan has been updated with the new register flow. Please check [OCF Registration Flow]
- Video with explanation and demonstration of new register flow [New Registration Demo]

#### New OpenCAPIF architecture

- New arquitecture with separated namespaces for Vault, CCF and Register components. Communication between them now are only allowed by using REST APIs.
- New helper service inside CCF, it will simplify integration with third parties like external management portals.

- Helper endpoints:
    - /getInvokers : Get the list of invokers from CAPIF
    - /getProviders: Get the list of providers from CAPIF
    - /getServices : Get the list of services published in CAPIF
    - /getSecurityContext : Get the list of security contexts from CAPIF
    - /getEvents : Get the list of events subscriptions from CAPIF
    - /deleteEntities: Removes all entities registered by a user from the register

- Security in the helper
    - To make requests to the helper you will need a superadmin certificate and password.

#### Events API Upgrade

- The event management at CCF is improved, EventNotification include Event Details with required information.
- Events updated:
    - SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE with apiIds
    - SERVICE_API_UPDATE with serviceAPIDescriptions
    - API_INVOKER_ONBOARDED, API_INVOKER_UPDATED, API_INVOKER_OFFBOARDED with apiInvokerIds.
- Events Included:
    - SERVICE_API_INVOCATION_SUCCESS and SERVICE_API_INVOCATION_FAILURE with invocationLogs
- Test plan include 7 new tests in order to check new events implemented and scenarios of each notification implemented, with a complete check of Event Notification.
- Test plan documentation includes the new event tests [OCF Event test plan documentation].

#### Inital implementation of CI/CD

- The inital implementation of CI/CD on gitlab was performed.
- Detailed information in the [CICD Wiki].
- Implement initial CI/CD:
    - Description of the CI process.
        - In CI phase, created design, jobs and security checks when a branch is pushed.
        - The CI has jobs as:
            - Linting code, unit test (if needed),
            - Build and push artifacts (images) in Git OCI register
            - Security checks,
            - SCA, CVS, SAST
            - The vulnerabilities are exposed in Merge Request panel to be solved.
    - Description of the CD process:
        - Defined the environments to OCF.
            - Production env.
            - Pre-production env.
            - Validation env.
            - Dev-1, dev-2… envs (ephemeral)
        - Defined the naming convention to OCF releases
            - Tag in prod: v0.0.1-release
            - Tag non-prod: v0.0.1-rc
            - Other tags: v0.0.1-test, v0.0.1-smt
        - Defined the jobs of CD
            - CD ensures the deployment in multiple envs. Therefore, the CD pipeline has deploy-ocf, delete-ocf (if needed) jobs
    - ETSI HIVE Labs:
        - Designed, created and the Kuberntes OCF cluster is running to support OCFs deployments.
        - Iterating with ETSI HIVE’s support to solve computing issues.
            - CPU compatibilities with OCF services (MongoDB): Fixed


### **Documentation**

#### Improvements on documentation

- Documentation stored in [OCF Documentation Repository]
- Continuous Integration included at repository for web documentation:
    - Develop version of documentation is automatically generated on each merge to develop branch.
    - Tagged version from main create documentation with related tag as version.

### **Technical Debt Solved**

#### Improved Testing with Robot in order to cover

- Support of new Register flows.
- Allow different URLs for register, ccf and vault services.
- New Variables included to manage new architecture under test.
- Mock server developed to add the functionality of write tests involving notification from Service Under Test.
- Docker image improved generation and libraries upgraded to Robot Framework 7.

#### Improved security on DB

- Credentials requested to access mongo databases.
- Credentials requested also by mongo-express.

#### Scripts upgraded

- Docker compose version 2 used on them.
- New cleaning script developed.
- Scripts upgraded:
    - **check_services_are_running.sh**: Checks if all essential services (Vault, CCF and Register) are running.
    - **clean_capif_docker_services.sh**: Shutdowns and removes all services essential services.
    - **clean_capif_temporary_files.sh**: Removes temporaly files from local repository. 
    - **run.sh**: Launch Essential services locally using docker compose, also monitoring can be launched.
    - **run_capif_tests.sh**: Launch Robot Framwork Tests.
    - **show_logs.sh**: Show locally logs of Services running.
    - **run_mock_server.sh**: Launch mock server locally on all interfaces. This axiliary server is only used by tagged mockserver tests on Robot Framework.
    - **clean_mock_server.sh**: Remove mock server local deployment.
    - **deploy.sh**: This script simplify the way to download capif repository.

#### Codebase Improvements

- Documentation is now on splitted repository [OCF Documentation Repository]
- Test plan was moved to [OCF Documentation Repository]
- Obsolote data is removed.
- Repository Reorganization: Enhanced structure and maintainability with a better directory layout and clearer module separation.
- Code Quality Enhancements: Refactored code and fixed known issues

#### Migration to GUNICORN

- Include production server on each microservice: Release 0 use Flask developer server, now we use GUNICORN.

---

## **Release 0.0**

The APIs included in Release 0.0 are:

- JWT Authentication APIs
- CAPIF Invoker Management API
- CAPIF Publish API
- CAPIF Discover API
- CAPIF Security API
- CAPIF Events API
- CAPIF Provider Management API

This Release also includes a Robot Test Suite for all those services and a Postman Test Suite for simple testing.


[OCF Documentation Repository]: https://labs.etsi.org/rep/ocf/documentation "OCF Documentation Repository"
[OCF Event test plan documentation]: https://ocf.etsi.org/documentation/latest/testing/testplan/api_events_service/ "OCF Event test plan documentation"
[OCF Registration Flow]: https://ocf.etsi.org/documentation/latest/testing/testplan/common_operations/ "OCF Registration Flow"
[New Registration Demo]: https://www.youtube.com/watch?v=sn-tN6eRvv8 "New Registration Demo"
[CICD Wiki]: https://labs.etsi.org/rep/ocf/community/-/wikis/OCF-CICD "CI/CD Wiki"
[Upgrade Release 17 to 18 Wiki]: https://labs.etsi.org/rep/ocf/community/-/wikis/?¿?¿?¿?¿?   "Upgrade Release 17 to 18 Wiki"
