## **Release 3.x.x**

### **New Features**

#### **Added Event Filters**

- New filters for Event service subscriptions.
    - You can now specify from which API, AEF, or Invoker you want to receive the event notifications.
    - These filters are specified in the ***eventFilters*** of the subscription if the ***Enhanced Event Report*** feature of the ***Supported Features*** is activated.
- More detailed information about event filters can be found in [Event Filter section](./event-filter/event-filter.md).

#### **Added Event Reporting Information**

- New Reporting Information for event subscriptions.
    - Now, you can specify the type of subscription you want: periodic, when an event is detected or one-time.
    - Fields have been added to allow setting a maximum number of notifications and the subscription expiration time.
    - You can now immediately get periodic notifications that have not been sent.
- More detailed information about the Reporting Information can be found in [Event Reporting Information section](./event-req/event-req.md)

### **Testing**

- New Event Filter test suite with 8 tests. [Event Filter test suite](./testing/testplan/event_filter/README.md)
- Removed supported Feature negotiation test because currently spec (v18.7.0) not support any feature.


### **Technical Debt Solved**

#### **Hardening on startup scripts for services interacting with Vault**

The startup scripts of the ***Invoker Management Service***, ***Provider Management Service***, and ***Security Service*** have been improved to ensure reliability when the Vault service takes longer to become ready. These new scripts check responses from the Vault to ensure the returned information is valid before starting each service.

This will also helps on the restart issue on k8s deployed OpenCAPIF.

#### Dynamic configurations
- Add new collection in CAPIF mongo with the init configuration.
- New endpoints in Helper to manage the CAPIF configuration.
- Add new collection in Register mongo with the init configuration.
- New endpoints in Register to manage the Register configuration.
- Documentation about Dynamic Configuration.
- Documentation about Helper and Register swaggers.

#### SupportedFeatures Negotiation

- Implemented in the API Provider Management the supported features negotiation for the suppFeat field during provider registration. The server now decodes the negotiated feature set based on client capabilities and system support.

- Code Review of Events API according to the supported features negotiation.

- Code Review of Discover API according to the supported features negotiation.

#### Security Method PKI

- Security API Service GET /trustedInvokers/{apiIncokerId} logic updated. Now it will check securityMethod selected and according to that, inserts on authenticationInfo and authorizedInfo attributes the needed information [PKI Flow](https://labs.etsi.org/rep/ocf/community/-/wikis/pki-flow)

#### Upgraded services version to 18.7.0

- OpenCAPIF services have been upgraded from version 18.4.0 to version 18.7.0 following 3GPP TS 29222.

### **Documentation**

#### Improvements over documentation
- New [Event Filter section](./event-filter/event-filter.md)
- New [Vendor Extensibility section](./vendor-ext/vendor-ext.md)
- New [API Status section](./api-status/api-status.md)
- New [Dynamic Configuration section](./configuration/configuration.md)
- New [Event Reporting Information section](./event-req/event-req.md)

#### Testplan
- New tests related with [Api Status Feature](./testing/testplan/api_status/README.md).
- New tests related with [Event Filter Feature](./testing/testplan/event_filter/README.md).
- New tests related with [Vendor Extensibility](./testing/testplan/vendor_extensibility/README.md)
- [Security Service Testplan](./testing/testplan/api_security_service/README.md) updated according to new features and Technical debts.
- New test on [Security Service Testplan](./testing/testplan/api_security_service/README.md) related with PKI security Method flow, GET request to security perform by AEF must returns CA_Root on authenticationInfo attribute at SecurityInfo.
- Removed supported Feature negotiation test of [API Access Control Policy](./testing/testplan/api_access_control_policy/README.md), because currently spec (v18.7.0) not support any feature.

## **Release 2.0.0**

### **New Features**

#### **Upgrade code to 3GPP CAPIF release 18**

- New endpoints included in new release 18 with new logic.
- Supported Features now are mandatory for all POST and PUT Requests as is described on TS 29.222. To keep in mind:
    - All POST/PUT request now must include ***Supported Features*** attribute, default can me set to ``0`` to keep all features inactive.
    - On subscription to Event, if you need ***eventDetails*** information on notification you must activate ***Enhanced Event Report*** feature by setting properly the ***Supported Features*** flag.
- Detailed information about models and endpoints upgrade on [Upgrade Release 17 to 18 Wiki]

#### **Vendor Extensibility**

- Check [Vendor Extensibility section](./vendor-ext/vendor-ext.md)
- Publish API:
    - On publishing a service API, **SupportedFeatures** is read and checked whether VendExt feature is enabled.
    - When VendExt is enabled, vendor-specific fields are searched and stored in the db inside the ServiceAPIDescription object
    - Vendor-specific fields are added according to the specific format:

```json

    "vendorSpecific-urn:<organization>:<field name>": {
        "key1": "value1",
        ...
        "keyN": "valueN",
    }
  
    e.g. 
    "vendorSpecific-urn:etsi:mec:capifext:transport-info": {
        "name": "trasport1",
        "description": "Transport Info 1",
        "type": "REST_HTTP",
        "protocol": "HTTP",
        "version": "2",
        "security": {
            "grantTypes": "OAUTH2_CLIENT_CREDENTIALS",
            "tokenEndpoint": "https://token-endpoint/"
        }
    }
  
    where organization is "etsi:mec" and field name "capifext:transport-info"

```

- Discover API:
    - On Discover request **SupportedFeatures** is read and checked whether VendSpecQueryParams feature is enabled.
    - When VendSpecQueryParams is enabled, vendor-specific query parameters are parsed
    - Vendor specific query parameters are added on the GET request according to the following format:

```json
    https://{{CAPIF_HOSTNAME}}:{{CAPIF_PORT}}/{{DISCOVER_URL}}?
           ...
           vend-spec-<query parameter name>={
              "target": <string that contains the JSON pointer to the attribute in the resource representation>, 
              "value": <query parameter value>
    }
  
    e.g. 
    https://{{CAPIF_HOSTNAME}}:{{CAPIF_PORT}}/{{DISCOVER_URL}}?
           ...
           vend-spec-type={
              "target": "/vendorSpecific-urn:etsi:mec:capifext:transport-info", 
              "value": "REST_HTTP"
    }
```


#### **Api Status feature**

- Check [API Status section](./api-status/api-status.md)
- New logic to support ***API Status*** feature on Publish and Events Services.
- Events API:
    - Event internal notifications between services improved to accomplish specification.
    - On event subscription **SupportedFeatures** is read and stored in db to accomplish specification.
    - Also **SupportedFeatures** is checked before send event notification, in order to accomplish specification, sending **eventDetails** and related information according to ***enhanced_event_report*** and ***apiStatusMonitoring*** supported features activated.


#### Remote Scripts

New scripts developed to help on remote deployment, configuration and testing. All this script are stored under helm/scripts in capif repository.

***variables.sh*** contains all configuration that will be used on remote operation. This file must be filled carefully before run remote scripts.

- Deployment Scripts:
    - ***install_vault.sh***: Deploy Vault component from k8s cluster, only needed if vault is not previously deployed. If it’s deployed you can setup vault token on variables.sh.
    - ***install_monitoring.sh***: Deploy monitoring on k8s cluster.
    - ***install_capif.sh***: Deploy OpenCAPIF on k8s cluster. It will be deployed on configured namespace with domain and hostnames configured under variables.sh.
    - ***uninstall_vault.sh***: Rollback Vault component from k8s cluster.
    - ***uninstall_monitoring.sh***: Rollback monitoring components from k8s cluster.
    - ***uninstall_capif.sh***: Rollback OpenCAPIF from k8s cluster.

- Manage remote users:
    - ***create_remote_users.sh***: This script create users setup by parameters on deployed OpenCAPIF. Those users are created by administrator.
    - ***remove_remote_users.sh***: This script removes user from deployed OpenCAPIF.
    - ***remove_remote_users_by_prefix.sh***:: This script removes users by prefix.

- Configuration of bastion machine, this simplify DNS fixed resolution:
    - ***get_ingress.sh***: This create a configuration for dns fixed resolution for ingress configured in namespace passed by parameters.
    - ***set_ingress.sh***: This scripts adds to /etc/hosts the fixed DNS resolution for ingress setup for  namespace passed by parameters.

- Execute robot tests over remote deployment.
    - ***run_remote_capif_tests.sh***: This scripts launch Robot Test docker image on current machine to reach deployed OpenCAPIF. Is useful to launch with “--include smoke” in order to ensure all is deployed properly.

- Just for testing, next scripts upload dummy information to deployed OpenCAPIF:
    - ***populate_create_remote_dummy_users.sh***: : Create Dummy providers and invokers, publish service APIs and creates security context for invokers.
    - ***populate_remove_remote_dummy_users.sh***: Remove dummy information created.

### New Tools and Components

#### SDK

New Python SDK is developed in order to simplify the creation and operation of providers and invokers. Please check the [SDK repository](https://labs.etsi.org/rep/ocf/sdk) for more information, there you can get more information about how to use it and also how to contibute to it.

#### Provider and Invoker example Clients

In order to help developers to create their own invokers/providers entities and try the behavior of the OpenCAPIF, we also add to the OCF respository two example with console interaction at [example clients repository](https://labs.etsi.org/rep/ocf/example-clients):

- [invoker-cli](https://labs.etsi.org/rep/ocf/example-clients/invoker-cli)
- [provider-cli](https://labs.etsi.org/rep/ocf/example-clients/provider-cli)

More information on README of each component.

### **Testing**

- New Vendor Extensibility test suite with 9 tests. [Api Events Service](./testing/testplan/vendor_extensibility/README.md)
- New [API Status feature](./testing/testplan/api_status/README.md) test suite with 20 tests.
- Improved [Events test suite](./testing/testplan/api_events_service/README.md) with 8 new tests.
- Test plan updated with default supported features for all request set to "0" (all inactive by default) [See common operations](./testing/testplan/common_operations/README.md).

### **Technical Debt Solved**

#### Local Scripts

- All scripts were reviewed and improved.
- New scripts to manage users on local deployment added:
    - ***create_users.sh***: This script create users setup by parameters in local deployment.. Those users are created by administrator.
    - ***remove_users.sh***: This script removes user in local deployment.

#### **Issues**

- Solved issue to get ready REDIS on deployment: REDIS scheduled on start to allow receive notification since service is deployed.
- Solved problem removing service APIs published is provider register more than one APF.
- Solved Superadmin problem deleting service API published through helper service if provider is not present.
- Increased the overall stability, fixing some corner cases.
- Location headers now are filled in same way at all services that needs it.
- Security issues solved.
- Base docker images present on ETSI registry.
- Robot image uploaded to ETSI Registry.

### **Documentation**

- [Postman examples](./testing/postman/README.md) are updated, including flows.
- New tests are detailed descripted on [Test plan section](./testing/testplan/README.md)
- New [Contribute section](./contribute/).
- New [SDK Section](./sdk/sdk.md)

---

## **Release 1.0.0**

### **New Features**

#### Registration Flow improved

- Eliminated access from CAPIF to the Register user database when onboarding is performed.
- Isolation between CCF and Register services, interaction now is only by HTTPS requested between Register, CCF and Vault.
- Eliminated the "role" in user creation.
    - Now a user can be an invoker or a provider at the same time
- Administrator User:
    - New entity in charge of registering and managing users of the register service.
- UUID to identify users.
    - When you create a user, a uuid is associated with it
    - The uuid will be contained in the token requested by the user and will be used to relate invokers and providers with users.
- Endpoints changed and created:
    - Administrator endpoints:
        - /createUser: /register endpoint changed to createUser. Used to register new users.
        - /deleteUser: /remove endpoint changed to this. Used to delete users and all the entities they had created.
        - /login: Allows administrator to log in to obtain the necessary tokens for their requests.
        - /refresh: Retrieve new access token token.
        - /getUsers: Returns the list with all registered users.
    - Customer User:
        - /getauth now also returns the urls needed to use CAPIF, used by customer.
- Security improvements:
    - /login uses basic auth with administrator credentials.
    - /getauth uses basic auth with customer user credentials.
    - Other requests use the administrator access token obtained from login.

- Current fields on user creation by administrator:
```
required_fields = {
    "username": str,
    "password": str,
    "enterprise": str,
    "country": str,
    "email": str,
    "purpose": str
}

optional_fields = {
    "phone_number": str,
    "company_web": str,
    "description": str
}
```

- Test plan has been updated with the new register flow. Please check [OCF Registration Flow]
- Video with explanation and demonstration of new register flow [New Registration Demo]

#### New OpenCAPIF architecture

- New arquitecture with separated namespaces for Vault, CCF and Register components. Communication between them now are only allowed by using REST APIs.
- New helper service inside CCF, it will simplify integration with third parties like external management portals.

- Helper endpoints:
    - /getInvokers : Get the list of invokers from CAPIF
    - /getProviders: Get the list of providers from CAPIF
    - /getServices : Get the list of services published in CAPIF
    - /getSecurityContext : Get the list of security contexts from CAPIF
    - /getEvents : Get the list of events subscriptions from CAPIF
    - /deleteEntities: Removes all entities registered by a user from the register

- Security in the helper
    - To make requests to the helper you will need a superadmin certificate and password.

#### Events API Upgrade

- The event management at CCF is improved, EventNotification include Event Details with required information.
- Events updated:
    - SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE with apiIds
    - SERVICE_API_UPDATE with serviceAPIDescriptions
    - API_INVOKER_ONBOARDED, API_INVOKER_UPDATED, API_INVOKER_OFFBOARDED with apiInvokerIds.
- Events Included:
    - SERVICE_API_INVOCATION_SUCCESS and SERVICE_API_INVOCATION_FAILURE with invocationLogs
- Test plan include 7 new tests in order to check new events implemented and scenarios of each notification implemented, with a complete check of Event Notification.
- Test plan documentation includes the new event tests [OCF Event test plan documentation].

#### Inital implementation of CI/CD

- The inital implementation of CI/CD on gitlab was performed.
- Detailed information in the [CICD Wiki].
- Implement initial CI/CD:
    - Description of the CI process.
        - In CI phase, created design, jobs and security checks when a branch is pushed.
        - The CI has jobs as:
            - Linting code, unit test (if needed),
            - Build and push artifacts (images) in Git OCI register
            - Security checks,
            - SCA, CVS, SAST
            - The vulnerabilities are exposed in Merge Request panel to be solved.
    - Description of the CD process:
        - Defined the environments to OCF.
            - Production env.
            - Pre-production env.
            - Validation env.
            - Dev-1, dev-2… envs (ephemeral)
        - Defined the naming convention to OCF releases
            - Tag in prod: v0.0.1-release
            - Tag non-prod: v0.0.1-rc
            - Other tags: v0.0.1-test, v0.0.1-smt
        - Defined the jobs of CD
            - CD ensures the deployment in multiple envs. Therefore, the CD pipeline has deploy-ocf, delete-ocf (if needed) jobs
    - ETSI HIVE Labs:
        - Designed, created and the Kuberntes OCF cluster is running to support OCFs deployments.
        - Iterating with ETSI HIVE’s support to solve computing issues.
            - CPU compatibilities with OCF services (MongoDB): Fixed


### **Documentation**

#### Improvements on documentation

- Documentation stored in [OCF Documentation Repository]
- Continuous Integration included at repository for web documentation:
    - Develop version of documentation is automatically generated on each merge to develop branch.
    - Tagged version from main create documentation with related tag as version.

### **Technical Debt Solved**

#### Improved Testing with Robot in order to cover

- Support of new Register flows.
- Allow different URLs for register, ccf and vault services.
- New Variables included to manage new architecture under test.
- Mock server developed to add the functionality of write tests involving notification from Service Under Test.
- Docker image improved generation and libraries upgraded to Robot Framework 7.

#### Improved security on DB

- Credentials requested to access mongo databases.
- Credentials requested also by mongo-express.

#### Scripts upgraded

- Docker compose version 2 used on them.
- New cleaning script developed.
- Scripts upgraded:
    - **check_services_are_running.sh**: Checks if all essential services (Vault, CCF and Register) are running.
    - **clean_capif_docker_services.sh**: Shutdowns and removes all services essential services.
    - **clean_capif_temporary_files.sh**: Removes temporaly files from local repository. 
    - **run.sh**: Launch Essential services locally using docker compose, also monitoring can be launched.
    - **run_capif_tests.sh**: Launch Robot Framwork Tests.
    - **show_logs.sh**: Show locally logs of Services running.
    - **run_mock_server.sh**: Launch mock server locally on all interfaces. This axiliary server is only used by tagged mockserver tests on Robot Framework.
    - **clean_mock_server.sh**: Remove mock server local deployment.
    - **deploy.sh**: This script simplify the way to download capif repository.

#### Codebase Improvements

- Documentation is now on splitted repository [OCF Documentation Repository]
- Test plan was moved to [OCF Documentation Repository]
- Obsolote data is removed.
- Repository Reorganization: Enhanced structure and maintainability with a better directory layout and clearer module separation.
- Code Quality Enhancements: Refactored code and fixed known issues

#### Migration to GUNICORN

- Include production server on each microservice: Release 0 use Flask developer server, now we use GUNICORN.

---

## **Release 0.0**

The APIs included in Release 0.0 are:

- JWT Authentication APIs
- CAPIF Invoker Management API
- CAPIF Publish API
- CAPIF Discover API
- CAPIF Security API
- CAPIF Events API
- CAPIF Provider Management API

This Release also includes a Robot Test Suite for all those services and a Postman Test Suite for simple testing.


[OCF Documentation Repository]: https://labs.etsi.org/rep/ocf/documentation "OCF Documentation Repository"
[OCF Event test plan documentation]: https://ocf.etsi.org/documentation/latest/testing/testplan/api_events_service/ "OCF Event test plan documentation"
[OCF Registration Flow]: https://ocf.etsi.org/documentation/latest/testing/testplan/common_operations/ "OCF Registration Flow"
[New Registration Demo]: https://www.youtube.com/watch?v=sn-tN6eRvv8 "New Registration Demo"
[CICD Wiki]: https://labs.etsi.org/rep/ocf/community/-/wikis/OCF-CICD "CI/CD Wiki"
[Upgrade Release 17 to 18 Wiki]: https://labs.etsi.org/rep/ocf/community/-/wikis/3GPP-Release-18-upgrade   "Upgrade Release 17 to 18 Wiki"
