# Event Reporting Information Feature

The Event Reporting Information Feature represents the requirements of the subscription, allowing users to specify the type of subscription they want, the maximum number of notifications they wish to receive, or the desired expiration date of the subscription, among other details.

## How it works

To use this feature, the supported feature **enhancedEventReport** must be enabled. With this feature activated, the **eventReq** field can be used when creating a new event subscription, containing the following information for CAPIF:

- **immRep**: Indicates an immediate report. If included and set to *true*, this specifies that periodic notifications that haven't been sent immediately for subscribed events should be sent. When a subscription is updated, all pending notifications are deleted, so it's very useful for receiving these notifications.

- **notifMethod**: Represents the notification method, which can be *PERIODIC* for subscriptions that receive notifications at regular intervals, *ONE_TIME* to receive only one notification, and *ON_EVENT_DETECTION* which sends the notification when the event occurs. If no method is specified, the default method used is *ON_EVENT_DETECTION*.

- **maxReportNbr**: Represents the maximum number of reports that can be sent before the subscription expires. It can be used with the *PERIODIC* and *ON_EVENT_DETECTION* methods, and if not specified, there is no limit.

- **monDur**: Represents the date on which the subscription expires. If no date is specified, there will be no time limit.

- **repPeriod**: Indicates the time interval in seconds between successive notification deliveries. It must be specified when the notification method is *PERIODIC*.

Using these fields provides significant benefits, such as enabling precise control over event notifications or ensuring that users receive the information when they need it. This flexibility allows for optimized resource usage, as unnecessary notifications are avoided, and the subscription can be tailored to specific use cases, improving overall efficiency and user satisfaction.


