# Test Plan for Event Filter Feature
At this documentation you will have all information and related files and examples of test plan for this feature.


## Test Case 1: Invoker subscrived to SERVICE_API_AVAILABLE, SERVICE_API_UNAVAILABLE and SERVICE_API_UPDATE events filtered by apiIds

**Test ID**: ***event_filter-1***
**Additional Tags**: ***mockserver***

**Description**:


**Pre-Conditions**:


**Execution Steps**:


**Expected Results**:


---
## Test Case 2: Invoker subscribed to SERVICE_API_AVAILABLE, SERVICE_API_UNAVAILABLE and SERVICE_API_UPDATE events filtered by not valid filters

**Test ID**: ***event_filter-2***
**Additional Tags**: ***smoke***

**Description**:


**Pre-Conditions**:


**Execution Steps**:


**Expected Results**:


---
## Test Case 3: Provider subscribed to API_INVOKER_ONBOARDED, API_INVOKER_OFFBOARDED and API_INVOKER_UPDATED events filtered by invokerIds

**Test ID**: ***event_filter-3***
**Additional Tags**: ***mockserver***

**Description**:


**Pre-Conditions**:


**Execution Steps**:


**Expected Results**:


---
## Test Case 4: Provider subscribed to API_INVOKER_ONBOARDED, API_INVOKER_OFFBOARDED and API_INVOKER_UPDATED events filtered by not valid filters

**Test ID**: ***event_filter-4***
**Additional Tags**: 

**Description**:


**Pre-Conditions**:


**Execution Steps**:


**Expected Results**:


---
## Test Case 5: Provider subscribed to ACCESS_CONTROL_POLICY_UPDATE event filtered by only apiId, only invokerId and both

**Test ID**: ***event_filter-5***
**Additional Tags**: ***smoke***, ***mockserver***

**Description**:


**Pre-Conditions**:


**Execution Steps**:


**Expected Results**:


---
## Test Case 6: Provider subscribed to ACCESS_CONTROL_POLICY_UPDATE event filtered by aefId

**Test ID**: ***event_filter-6***
**Additional Tags**:

**Description**:


**Pre-Conditions**:


**Execution Steps**:


**Expected Results**:


---
## Test Case 7: Provider subscribed to SERVICE_API_INVOCATION_SUCCESS and SERVICE_API_INVOCATION_FAILURE filtered by apiId, invokerId, aefId and all of them

**Test ID**: ***event_filter-7***
**Additional Tags**: **smoke**, **mockserver**

**Description**:


**Pre-Conditions**:


**Execution Steps**:


**Expected Results**:


---

**UNDER DEVELOPMENT**
---
## Test Case 1: Service API Available filtered by apiIds

**Test ID**: ***event_filter-1***

**Description**:

  This test case will check if an invoker subscribed to events **SERVICE_API_AVAILABLE**, **SERVICE_API_UNAVAILABLE** and **SERVICE_API_UPDATE** with ***apiStatusMonitoring*** and **Enhanced_event_report** active, receive SERVICE_API_AVAILABLE in mockserver when api is published by a provider, containing eventDetails, SERVICE_API_UPDATE and SERVICE_API_UNAVAILABLE after update apiStatus to empty aefIds array with **ApiStatusMonitoring** active.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered with 2 aefs.
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:

   1. Register Invoker and Onboard Invoker at CCF.
   2. Register Provider at CCF with 2 aefs.
   3. Publish Service API at CCF:
      1. Supported Features with apiStatusMonitoring flag active (binary 0 0010 0000 -> string **020**)
      2. This API includes "API Status" information at **service API Description** with only aefId1.
   4. Discover Service APIs by Invoker
      1. includes filter by query parameter **aef-id**
   5. Invoker Subscribes to **SERVICE_API_AVAILABLE**, **SERVICE_API_UNAVAILABLE** and **SERVICE_API_UPDATE**. **apiStatusMonitoring** and **Enhanced_event_report** **active** at supported features (binary 1100-> string **C**). Filter by published **apiId**.
   6. Update Published API:
      1. apiStatus present with empty aefIds array.
      2. apiStatusMonitoring feature active (binary 0 0010 0000 -> string **20**)

**Information of Test**:

   1. Perform [Invoker Onboarding]
   2. Perform [Provider Registration] with 2 aefs
   3. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with **service_1** and **service_2** apiNames and realted with aefId1 and aefId2.
       * supportedFeatures **020**
       * 2 profiles, one with each aef.
       * apiStatus with aefId1 inside array
     * Use **APF Certificate**
   4. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**
   5. Event Subscription to SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE of provider previously registered:
       1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
       2. body [event subscription request body] with:
          1. events: **['SERVICE_API_AVAILABLE','SERVICE_API_UNAVAILABLE','SERVICE_API_UPDATE']**
          2. supportedFeatures: binary 1100 -> string **C**
          3. eventFilters set to [eventFilters:[{apiIds:['{API_ID}']},{apiIds:['{API_ID}']},{apiIds:['{API_ID}']}]]
       3. Use **Invoker Certificate**
   6. Update published Service API:
     * Send **PUT** to resource URL **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis/{SERVICE_API_ID}**
     * Use **APF Certificate**
     * body [service api description] with **service_1** and **service_2** apiNames and realted with aefId1 and aefId2.
       * supportedFeatures **20**
       * 2 profiles, one with each aef.
       * apiStatus present with empty aefIds array.

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**
  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  3. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
        * 2 profiles with:
          * resourceName resource_1 and aefId1
          * resourceName resource_2 and aefId2
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
  4. Response to Discover Request By Invoker:
     1. **200 OK** response.
     2. Response body must follow **DiscoveredAPIs** data structure:
        * Check if DiscoveredAPIs contains the API Published previously
          * Check if contains the **apiStatus** with aefId1
  5. Response to Update published Service API at CCF:
     1. **200 OK**
     2. Store response with updated serviceAPIDescription.
  6. Mock Server received messages must accomplish:
     1. **Two Event have been received**.
     2. Validate received events follow **EventNotification** data structure, with **apiIds** and **serviceAPIDescription** in **eventDetail** parameter.
        1. One should be **SERVICE_API_AVAILABLE**.
        2. One should be **SERVICE_API_UPDATE**.
        3. One should be **SERVICE_API_UNAVAILABLE**.


---




   [service api description]: ../api_publish_service/service_api_description_post_example.json  "Service API Description Request"
   [service api description patch]: ../api_publish_service/service_api_description_patch_example.json  "Service API Description Patch Request"
   [publisher register body]: ../api_publish_service/publisher_register_body.json  "Publish register Body"
   [invoker onboarding body]: ../api_invoker_management/invoker_details_post_example.json  "API Invoker Request"
   [provider request body]: ../api_provider_management/provider_details_post_example.json  "API Provider Enrolment Request"
   [provider request patch body]: ../api_provider_management/provider_details_enrolment_details_patch_example.json  "API Provider Enrolment Patch Request"

   [invoker onboarding]: ../common_operations/README.md#onboard-an-invoker "Invoker Onboarding"
   [provider registration]: ../common_operations/README.md#register-a-provider "Provider Registration"
   [event subscription request body]: ../api_events_service/event_subscription.json  "Event Subscription Request"
