# Invoker and Provider CLIs
The Invoker and Provider CLIs serve as examples for developers and integrators looking to connect their Network Applications (NetApps) to CAPIF. 

They demonstrate, using Python, how to develop the necessary code for seamless communication with CAPIF, offering a practical guide to implementing the required API calls and interactions.

## Provider CLI
When using the [Provider Console](https://labs.etsi.org/rep/ocf/example-clients/provider-cli), users can create a provider entity that registers and publishes APIs to make them available within the CAPIF ecosystem. 

### Commands
With the provider console you can make the following requests to CAPIF:

#### provider_get_auth
It is used to request the token and the ca_root certificate in order to perform the provider onboarding.

```
provider_get_auth <username> <password>
```

The token has an expiration time of 10 minutes, so if it expires you will have to request a new one.

#### register_provider
It is used to perform the onboarding of a provider.

```
register_provider <name>
```

This request uses the [api_provider_domain.json](https://labs.etsi.org/rep/ocf/example-clients/provider-cli/-/blob/main/one_provider_gui/capif_ops/config_files/api_provider_domain.json?ref_type=heads) file as a template and creates the certificates and keys for each of the entities that make up the Provider.

#### publish_service

It is used to publish an api as a provider.

```
publish_service <service file route>
```

For this request the [demo_api_one.json](https://labs.etsi.org/rep/ocf/example-clients/provider-cli/-/blob/main/one_provider_gui/service/demo_api_one.json?ref_type=heads) file is used as a template.

#### get_services
It is used to see what services the provider has published.

```
get_service 
```

Returns a list of API names.

#### remove_service
It is used to unpublish an API.

```
remove_service <api name>
```

#### remove_provider
It is used to remove the provider.

```
remove_provider
```

Once the provider is deleted, you will not be able to publish or perform other operations that require certificates.

### Additionally

In addition, an [API example](https://labs.etsi.org/rep/ocf/example-clients/provider-cli/-/blob/main/one_provider_gui/service/service_oauth.py?ref_type=heads) is provided with which you can see how the token used by invokers to use the API published by the provider is decrypted and used.

Once the API is published, the file can be executed with the next command:

```
python3 service_oauth.py
```

With this, the API will be raised to be able to make the calls.

## Invoker CLI
When using the [Invoker Console](https://labs.etsi.org/rep/ocf/example-clients/invoker-cli), users can create an Invoker entity that discover APIs to consume them with the CAPIF ecosystem. 

### Commands
With the Invoker console you can make the following requests to CAPIF:

#### get_auth
It is used to request the token and CA cert to be able to perform the onboarding.

```
get_auth <username> <password>
```

The token has an expiration time of 10 minutes, so if it expires you will have to request a new one.

#### register_invoker
It is usedd to perform the onboarding of an Invoker,

```
register_invoker <name>
```

This request uses the [invoker_details.json](https://labs.etsi.org/rep/ocf/example-clients/invoker-cli/-/blob/main/invoker_gui/capif_ops/config_files/invoker_details.json?ref_type=heads) file as a template and creates the certificate and keys of the Invoker.

#### discover_service
It is used to discover the APIs published in CAPIF.

```
discover_service
```

Returns a list with the names of the services published in CAPIF.

#### register_security_context
It is used to make the request to create a security context.

```
register_security_context <api name>
```

#### get_security_auth
It is used to request the token necessary for the cunsumption of an API.

```
get_security_auth <api name>
```

#### call_service
It is used to consume the API

```
call_service <api name> <method> <endpoint> <body route>
```

For the request you must specify the name of the API you want to use, the method and endpoint you want to consume, and the path of the body to use.

#### remove_security_context
It is used to delete the created security context.

```
remove_security_context
```

#### remove_invoker
It is used to delete the Invoker

```
remove_invoker
```

Once the invoker is deleted, you will not be able to discover or perform other operations that require the Invoker certificate.

## Other commands
Apart from these operations, with the Invoker and Provider console you can also perform operations as administrator if you have a CAPIF instance locally.

### Admin commands
As an administrator, you can manage which users can use CAPIF with the following commands.

#### login_admin
It is used to login as an administrator and obtain the tokenes needed to perform admin operations

```
login_admin <admin username> <admin password>
```

#### refresh_admin
It is used to refresh the tokenes of the admin user

```
refresh_admin
```

#### register_user
It is used to register a new user

```
register_user
```

uses the data in the [credentials.properties](https://labs.etsi.org/rep/ocf/example-clients/invoker-cli/-/blob/main/invoker_gui/capif_ops/config_files/credentials.properties?ref_type=heads) file as the data to record.

#### remove_user
It is used to remove the created user.

```
remove_user
```

## Tips
This section explains some tips that may be useful for developers who are using consoles.

### help command
In both consoles you can use the help command to display a list of available commands.

```
help
```

### exit command
In both consoles you can use the exit command to exit the console.

```
exit
```

### Delete the entities
It is recommended to delete all providers, Invokers and users created by the consoles if they are not going to be used anymore.

### debug mode
You can add the debug flag at the end of each command to show the complete inputs and outputs of each request and thus better understand what is being done.

```
register_invoker ocf debug
```


[OCF Web]: https://ocf.etsi.org/ "OCF Web"
[OCF Documentation]: https://ocf.etsi.org/documentation/ "OCF Documentation"
