# Common Operations

## Default Supported Features

By default all required supported features on POST Request will be present and set to "0" unless test define it with other value. Also it can be set to NONE is we want to test supported features not present.

## Register new user

In order to use OpenCAPIF we must add a new user. This new user can onboard/register any Invokers or Providers.

That new user **must be created by administrator** of Register Service and with the credentials shared by administrator, the new user can get the **access_token** by requesting it to Register service.

The steps to register a new user at Register Service are:

### Admin create User
1) **Login as Admin to get access_token:**

  * Send **POST** to **https://${CAPIF_REGISTER}:${CAPIF_REGISTER_PORT}/login**
    * **Include basic Auth Header with Admin credentials**
  * Get **access_token** and **refresh_token** from response

![Flow](../../../images/flows/01_Login_Admin.png)

2) **Create User:**

  * Send **POST** to **https://${CAPIF_REGISTER}:${CAPIF_REGISTER_PORT}/createUser**
    * Include Admin **access_token** in **Authorization Bearer Header**
    * Body [user_registration_body]

![Flow](../../../images/flows/02_Creation_of_user.png)

### User Retrieve access token and other information
1) **Retrieve access_token by User:**

  * Send **GET** to **https://${CAPIF_REGISTER}:${CAPIF_REGISTER_PORT}/getauth**
    * Include **basic Auth Header with User credentials**
  * Retrieve **access_token** and the urls needed for next requests from response body [user_getauth_response_body_example]

![Flow](../../../images/flows/03_Register_of_AEF_GetAuth.png)

## Onboard an Invoker

### Steps to perform operation
***Preconditions: The administrator must have previously registered the User.***

  1. Create public and private key at invoker
  2. Retrieve access_token by User:

    * Send **GET** to **https://${CAPIF_REGISTER}:${CAPIF_REGISTER_PORT}/getauth**
      * Include basic Auth Header with Admin user/password
    * Retrieve **access_token** and the urls needed for next requests from response body [user_getauth_response_body_example]

  3.  Onboard Invoker:     

     * Send **POST** to **https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers**
     * Reference Request Body: [invoker onboarding body]
     * "onboardingInformation"->"apiInvokerPublicKey": must contain public key generated by Invoker.
     * Send in Authorization Header the Bearer access_token obtained previously (Authorization:Bearer ${access_token})

### Checks to ensure onboarding

   2. Response to Get Auth:
      1. **200 OK**
      2. ***access_token*** returned.

   3. Response to Onboard request must accomplish:
      1. **201 Created**
      2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
         * apiInvokerId
         * onboardingInformation->apiInvokerCertificate must contain the public key signed.
      3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**

### Example Flow
![Flow](../../../images/flows/07_Invoker_Onboarding.png)

## Register a Provider

### Steps to Perform operation
  1. Create public and private key at provider for provider itself and each function (apf, aef and amf)
  2. Retrieve access_token by User:

    * Send **GET** to **https://${CAPIF_REGISTER}:${CAPIF_REGISTER_PORT}/getauth**
      * Include basic Auth Header with Admin user/password
    * Retrieve **access_token** and the urls needed for next requests from response body [user_getauth_response_body_example]

  3. Register Provider:

     * Send **POST** **https://{CAPIF_HOSTNAME}/api-provider-management/v1/registrations**
     * body [provider request body]
     * Send in Authorization Header the Bearer access_token obtained previously (Authorization:Bearer ${access_token})
     * Store each cert in a file with according name.

### Checks to ensure provider registration
   1. Response to Register:
      1. **201 Created**

   2. Response to Get Auth:
      1. **200 OK**
      2. ***access_token*** returned.

   3. Register Provider at Provider Management:
      1. **201 Created** response.
      2. body returned must accomplish **APIProviderEnrolmentDetails** data structure.
      3. For each **apiProvFuncs**, we must check:
         1. **apiProvFuncId** is set
         2. **apiProvCert** under **regInfo** is set properly
      4. Location Header must contain the new resource URL **{apiRoot}/api-provider-management/v1/registrations/{registrationId}**

### Example Flow
![Flow](../../../images/flows/07_Invoker_Onboarding.png)


## Subscribe to Events

Subscription to an Event by any entity (Invoker, Provider or other CCF), will ensure when subscription is matched one event will be sent to notification destination present on subscription creation.

### How to create a subscription

In order to create a subcription, customer must setup some different parameters.

#### Basic Subscription

Basic subcription will be used when Enhanced_event_report feature is not active at supportedFeatures attribute at [event subscription request body], this means this kind of subcription:

* Won't be filtered by eventFilters.
* Reporting specific requierements won't be enable (eventReq).
* Response will only contains basic information without eventDetail.

With this in mind, customer must select next parameters:

##### Events to subscribe

Select event or events to subscribe. Check from next list:

| Event                             | Description                                                                                                                              |     Status      |
| :-------------------------------- | :--------------------------------------------------------------------------------------------------------------------------------------- | :-------------: |
| SERVICE_API_AVAILABLE             | Events related to the availability of service APIs after the service APIs are published.                                                 |   Implemented   |
| SERVICE_API_UNAVAILABLE           | Events related to the unavailability of service APIs after the service APIs are unpublished.                                             |   Implemented   |
| SERVICE_API_UPDATE                | Events related to change in service API information.                                                                                     |   Implemented   |
| API_INVOKER_ONBOARDED             | Events related to API invoker onboarded to CAPIF.                                                                                        |   Implemented   |
| API_INVOKER_OFFBOARDED            | Events related to API invoker offboarded from CAPIF.                                                                                     |   Implemented   |
| SERVICE_API_INVOCATION_SUCCESS    | Events related to the successful invocation of service APIs.                                                                             |   Implemented   |
| SERVICE_API_INVOCATION_FAILURE    | Events related to the failed invocation of service APIs.                                                                                 |   Implemented   |
| ACCESS_CONTROL_POLICY_UPDATE      | Events related to the update for the access control policy related to the service APIs.                                                  |   Implemented   |
| ACCESS_CONTROL_POLICY_UNAVAILABLE | Events related to the unavailability of the access control policy related to the service APIs (NOTE).                                    |   Implemented   |
| API_INVOKER_AUTHORIZATION_REVOKED | Events related to the revocation of the authorization of API invokers to access the service APIs. (NOTE).                                |   Implemented   |
| API_INVOKER_UPDATED               | Events related to API invoker profile updated to CAPIF.                                                                                  |   Implemented   |
| API_TOPOLOGY_HIDING_CREATED       | Events related to the creation or update of the API topology hiding information of the service API after the service APIs are published. | Not Implemented |
| API_TOPOLOGY_HIDING_REVOKED       | Events related to the revocation of the API topology information of the service API after the service APIs are unpublished.              | Not Implemented |

**NOTE**: 3GPP Common API Framework release 19 specs not specify further details (e.g event filters) for this event.

##### Notification Destination

* Set ***notification destination*** at [event subscription request body] with the endpoint to be reached by CCF when an event matches.

#### Enhanced Subscription

Enhanced will be the requiered subscription if customer needs one or more next functionality:

* Filter events. (eventFilters)
* Setup some reporting requirements. (eventReq)
* Get more detailed information when event notification is received (eventDetail on response)

If that is the case, then [event subscription request body] must setup supported features with Enhanced_event_report feature active (feature 3)

With this feature active, customer can send eventFilter and EventReq with required information.

##### Event Filter

We can include an array for each suscribed array with desired eventFilter to be applied, but we need to keep in mind not all events allows all filters, take a look to next table:

| Event                             | Event filter allowed           |
| :-------------------------------- | :----------------------------- |
| SERVICE_API_AVAILABLE             | apiIds                         |
| SERVICE_API_UNAVAILABLE           | apiIds                         |
| SERVICE_API_UPDATE                | apiIds                         |
| API_INVOKER_ONBOARDED             | apiInvokerIds                  |
| API_INVOKER_OFFBOARDED            | apiInvokerIds                  |
| SERVICE_API_INVOCATION_SUCCESS    | apiIds, apiInvokerIds, aefIds. |
| SERVICE_API_INVOCATION_FAILURE    | apiIds, apiInvokerIds, aefIds. |
| ACCESS_CONTROL_POLICY_UPDATE      | apiIds, apiInvokerIds.         |
| ACCESS_CONTROL_POLICY_UNAVAILABLE | -                              |
| API_INVOKER_AUTHORIZATION_REVOKED | -                              |
| API_INVOKER_UPDATED               | apiInvokerIds                  |
| API_TOPOLOGY_HIDING_CREATED       | -                              |
| API_TOPOLOGY_HIDING_REVOKED       | -                              |

##### Event Req

Currently not implemented

### Steps to Perform operation

  1. Perform [invoker onboarding] or [provider registration]
  2. Event Subscription:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. body [event subscription request body]
     3. Use **Invoker Certificate** or **AMF Provider Certificate**


### Checks to ensure provider registration
   1. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.



[user_registration_body]: ./user_registration_body.json  "User Registration Body"
[user_getauth_response_body_example]: ./user_getauth_response_body_example.json  "User GetAuth response Body Example"

[invoker onboarding body]: ../api_invoker_management/invoker_details_post_example.json  "API Invoker Request"
[invoker getauth body]: ../api_invoker_management/invoker_getauth_example.json    "Get Auth Example"

[provider request body]: ../api_provider_management/provider_details_post_example.json  "API Provider Enrolment Request"

[event subscription request body]: ../api_events_service/event_subscription.json  "Event Subscription Request"

[invoker onboarding]: #onboard-an-invoker "Invoker Onboarding"
[provider registration]: #register-a-provider "Provider Registration"


[Return To All Test Plans]: ../README.md
