# Event Filter

The **Event Filter** is a feature of the CAPIF Events service that allows you to receive specific notifications about the events you are subscribed to. This tool is essential for efficiently managing and monitoring relevant events, ensuring that users receive only the information they need.

## How it works

To specify the desired filter during subscription, you can use the ***eventFilters*** field, provided that the ***Enhanced Event Report*** flag is enabled in the ***Supported Features*** characteristics.

The ***eventFilters*** field consists of a list of filters that correspond one-to-one with the list of events in the ***events*** field. Thus, the first element of the filter list corresponds to the first element of the events list, the second filter element to the second event element, and so on.

Each filter contains three lists:

- **apiIds**: Identifiers of the APIs from which you want to receive notifications.
- **apiInvokerIds**: Identifiers of the invokers from which you want to receive notifications.
- **aefIds**: Identifiers of the AEFs from which you want to receive notifications.

Depending on the event you subscribe to, you can use one or more of these lists. The following table shows the filtering options available for each event:

| Event                           | apiIds | aefIds | apiInvokerIds |
|---------------------------------|:------:|:------:|:-------------:|
| SERVICE_API_AVAILABLE           |   X    |        |               |
| SERVICE_API_UNAVAILABLE         |   X    |        |               |
| SERVICE_API_UPDATE              |   X    |        |               |
| API_INVOKER_ONBOARDED           |        |        |       X       |
| API_INVOKER_OFFBOARDED          |        |        |       X       |
| API_INVOKER_UPDATED             |        |        |       X       |
| ACCESS_CONTROL_POLICY_UPDATE    |   X    |        |       X       |
| SERVICE_API_INVOCATION_SUCCESS  |   X    |   X    |       X       |
| SERVICE_API_INVOCATION_FAILURE  |   X    |   X    |       X       |
| API_TOPOLOGY_HIDING_CREATED     |        |        |               |
| API_TOPOLOGY_HIDING_REVOKED     |        |        |               |

In cases where 2 or 3 lists are specified simultaneously for an event, notifications will only be sent when there is at least one matching element in each of the subscription lists. For example, if you subscribe to the ***ACCESS_CONTROL_POLICY_UPDATE*** event using the ***apiIds*** and ***apiInvokerIds*** filter lists, you will only be notified when the access control policy update corresponds to an API in the ***apiIds*** list and an invoker in the ***apiInvokerIds*** list at the same time.

[OCF Web]: https://ocf.etsi.org/ "OCF Web"
[OCF Documentation]: https://ocf.etsi.org/documentation/ "OCF Documentation"
