# Test Plan for CAPIF Api Events Service
At this documentation you will have all information and related files and examples of test plan for this API.

## Tests

## Test Case 1: Creates a new individual CAPIF Event Subscription.

**Test ID**: ***capif_api_events-1***

**Description**:

  This test case will check that a CAPIF subscriber (Invoker or Publisher) can Subscribe to Events
**Pre-Conditions**:
  
  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Event Subscription:
     1. Send POST to *https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions*
     2. body [event subscription request body]
     3. Use Invoker Certificate

**Execution Steps**:
  
  1. Register Invoker and Onboard Invoker at CCF
  2. Subscribe to Events
  3. Retrieve {subscriberId} and {subscriptionId} from Location Header
   
**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: *{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}*

  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: *{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}
     3. Response Body must follow **EventSubscription** data structure.

  3. Event Subscriptions are stored in CAPIF Database


## Test Case 2: Creates a new individual CAPIF Event Subscription with Invalid SubscriberId

**Test ID**: ***capif_api_events-2***

**Description**:

  This test case will check that a CAPIF subscriber (Invoker or Publisher) cannot Subscribe to Events without valid SubcriberId

**Pre-Conditions**:
  
  * CAPIF subscriber is not pre-authorised (has invalid InvokerId or apfId)

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Event Subscription:
     1. Send POST to *https://{CAPIF_HOSTNAME}/capif-events/v1/{SUBSCRIBER_NOT_REGISTERED}/subscriptions*
     2. body [event subscription request body]
     3. Use Invoker Certificate

**Execution Steps**:
  
  1. Register Invoker and Onboard Invoker at CCF
  2. Subscribe to Events
   
**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: *{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}*

  2. Response to Event Subscription must accomplish:
     1. **404 Not Found**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 404
        * title with message "Not Found"
        * detail with message "Invoker or APF or AEF or AMF Not found".
        * cause with message "Subscriber Not Found".

  3. Event Subscriptions are not stored in CAPIF Database

  
## Test Case 3: Deletes an individual CAPIF Event Subscription

**Test ID**: ***capif_api_events-3***

**Description**:

  This test case will check that a CAPIF subscriber (Invoker or Publisher) can Delete an Event Subscription

**Pre-Conditions**:
  
  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Event Subscription:
     1. Send POST to *https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions*
     2. body [event subscription request body]
     3. Use Invoker Certificate

  3. Remove Event Subscription:
     1. Send DELETE to *https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions*
     2. Use Invoker Certificate

**Execution Steps**:
  
  1. Register Invoker and Onboard Invoker at CCF
  2. Subscribe to Events
  3. Retrieve {subscriberId} and {subscriptionId} from Location Header
  4. Remove Event Subscription
   
**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: *{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}*

  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: *{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}
     3. Response Body must follow **EventSubscription** data structure.

  3. Event Subscriptions are stored in CAPIF Database
  4. Remove Event Subscription:
     1. **204 No Content**

  5. Event Subscription is not present at CAPIF Database.


## Test Case 4: Deletes an individual CAPIF Event Subscription with invalid SubscriberId

**Test ID**: ***capif_api_events-4***

**Description**:

  This test case will check that a CAPIF subscriber (Invoker or Publisher) cannot Delete to Events without valid SubcriberId

**Pre-Conditions**:
  
  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId).
  * CAPIF subscriber is subscribed to Events.

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Event Subscription:
     1. Send POST to https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions
     2. body [event subscription request body]
     3. Use Invoker Certificate

  3. Remove Event Subcription with not valid subscriber:
     1. Send DELETE to to https://{CAPIF_HOSTNAME}/capif-events/v1/{SUBSCRIBER_ID_NOT_VALID}/subscriptions/{subcriptionId}
     2. Use Invoker Certificate

**Execution Steps**:
  
  1. Register Invoker and Onboard Invoker at CCF
  2. Subscribe to Events
  3. Retrieve Location Header with subscriptionId.
  4. Remove Event Subscribed with not valid Subscriber.
   
**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: *{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}*

  2. Response to Event Subscription must accomplish:
     1. 201 Created
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: *{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}
     3. Response Body must follow **EventSubscription** data structure.

  3. Event Subscriptions are stored in CAPIF Database
  4. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 404
        * title with message "Not Found"
        * detail with message "Invoker or APF or AEF or AMF Not found".
        * cause with message "Subscriber Not Found".


## Test Case 5: Deletes an individual CAPIF Event Subscription with invalid SubscriptionId

**Test ID**: ***capif_api_events-5***

**Description**:

  This test case will check that a CAPIF subscriber (Invoker or Publisher) cannot Delete an Event Subscription without valid SubscriptionId

**Pre-Conditions**:
  
  * CAPIF subscriber is pre-authorised (has invalid InvokerId or apfId).
  * CAPIF subscriber is subscribed to Events.

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Event Subscription:
     1. Send POST to https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions
     2. body [event subscription request body]
     3. Use Invoker Certificate

  3. Remove Event Subcription with not valid subscriber:
     1. Send DELETE to to https://{CAPIF_HOSTNAME}/capif-events/v1/{subcriberId}/subscriptions/{SUBSCRIPTION_ID_NOT_VALID}
     2. Use Invoker Certificate

**Execution Steps**:
  
  1. Register Invoker and Onboard Invoker at CCF
  2. Subscribe to Events
  3. Retrieve Location Header with subscriptionId.
  4. Remove Event Subscribed with not valid Subscriber.
   
**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: *{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}*

  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: *{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}
     3. Response Body must follow **EventSubscription** data structure.

  3. Event Subscriptions are stored in CAPIF Database
  4. Remove Event Subscription with not valid subscriber:
     1. **404 Not Found**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 404
        * detail with message "Service API not existing".
        * cause with message "Event API subscription id not found".


## Test Case 6: Invoker receives Service API Invocation events

**Test ID**: ***capif_api_events-6***

**Description**:

  This test case will check that a CAPIF Invoker subscribed to SERVICE_API_INVOCATION_SUCCESS and SERVICE_API_INVOCATION_FAILURE, receive the notification when AEF send to logging service result of invocations to their APIs.

**Pre-Conditions**:
  
  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered and published APIs.
  * API Provider had a Service API Published on CAPIF
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Information of Test**:

  1. Perform [provider registration]
  2. Publish Service API at CCF:

     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
     * Store *serviceApiId*
     * Use APF Certificate

  3. Perform [invoker onboarding]
  4. Discover published APIs:

     * Get Api Ids And Api Names from response.

  5. Event Subscription to SERVICE_API_INVOCATION_SUCCESS and SERVICE_API_INVOCATION_FAILURE of provider previously registered:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. body [event subscription request body] with:
        1. events: **['SERVICE_API_INVOCATION_SUCCESS','SERVICE_API_INVOCATION_FAILURE']**
        2. eventFilter: only receive events from provider's aefId.
     3. Use Invoker Certificate

  7. Create Log Entry emulating provider receive Success and Failure api invocation from invoker:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/api-invocation-logs/v1/{aefId}/logs**
     2. body [log entry request body] with:
        1. aefId from provider published.
        2. apiInvokerId from invoker onboarded.
        3. apiId of published API
        4. apiName of published API
        5. 200 and 400 results in two logs.
     3. Use AEF Certificate
 

**Execution Steps**:
  
  1. Register provider and publish one API at CCF
  2. Register Invoker and Onboard Invoker at CCF
  3. Discover published APIs and extract apiIds and apiNames
  4. Subscribe to **SERVICE_API_INVOCATION_SUCCESS** and **SERVICE_API_INVOCATION_FAILURE** event filtering by aefId.
  5. Retrieve {subscriberId} and {subscriptionId} from Location Header
  6. Emulate Success and Failure on API invocation of provider by Invoker, using Invocation Logs API.
   
**Expected Result**:

  1. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  2. Response to creation of log entry on CCF must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/api-invocation-logs/{apiVersion}/{aefId}/subscriptions/{logId}**
  3. Mock Server received messages must accomplish:ç
     1. **Two Events have been received**.
     2. Validate received events follow **EventNotification** data structure, with **invocationLog** in **eventDetail** parameter.
        1. One should be **SERVICE_API_INVOCATION_SUCCESS** related with **200** result at Log.
        2. The other one must be **SERVICE_API_INVOCATION_FAILURE** related with **400** result at Log.






[invoker onboard request body]: ../api_invoker_management/invoker_details_post_example.json  "API Invoker Request"
[event subscription request body]: ./event_subscription.json  "Event Subscription Request"
[invoker onboarding]: ../common_operations/README.md#onboard-an-invoker "Invoker Onboarding"
[provider registration]: ../common_operations/README.md#register-a-provider "Provider Registration"
[log entry request body]: ../api_logging_service/invocation_log.json "Log Request Body"


[Return To All Test Plans]: ../README.md
