<img src="images/openslice_logo.png" alt="drawing" width="200"/>

version: 2023Q4 - Release 0

The ETSI Software Development Group for OpenSlice (SDG OSL) is developing an open source service based Operations Support System (OSS) to deliver Network Slice as a Service (NSaaS) following specifications from major SDOs including ETSI, TM Forum and GSMA. See more details [here](https://osl.etsi.org/about/).


## Usage

OpenSlice allows Vertical Customers to browse the available offered service specifications and also allows NFV developers to onboard and manage VNF and Network Service artifacts. It also supports TMFORUM OpenAPIs regarding Service Catalog Management, Ordering, Resource, etc.
The following figure displays the usage of OpenSlice.

[![OpenSlice  usage](./images/index_intro_architecture.png)](./images/index_intro_architecture.png)


There are two portals offering UI friendly access to users:

* The Services portal allows users to access services and service providers to design services. 
* The NFV portal allows users to self-manage NFV artifacts and onboard them to a target MANO/NFV Orchestrator.

3rd party applications can use OpenSlice through TMForum Open APIs.

Service Specifications reside into Service Catalogs, grouped in Categories. OpenSlice offers a Service Orchestrator called [OSOM](./architecture/osom.md). OSOM instantiates Service Specifications by requesting Network Services from target MANOs/NFVOs. NFV artifacts reside into a VNF/NSD catalog and are onboarded to a target MANO/NFV Orchestrator. Service Specifications reference NSD from the VNF/NSD catalog. 

Customers make Service Orders and OpenSlice instantiates the requested Service Specifications of the Service Order. Running Services instantiated by OpenSlice, reside in OpenSlice Service Inventory. The following picture displays how Service Specifications are related to Running Services and how Running Services relate with instantiated running Network Services. (See also [Service Inventory](./service_inventory.md))

[![OpenSlice  Service Specification instantiation](./images/service_specification_instantiation.png)](./images/service_specification_instantiation.png)

## Service Lifecycle Rules

OpenSlice constains support for defining rules of services, affecting their behavior. See [LCM Rules](./lcm.md).

## Multidomain scenarios and federation

OpenSlice can be used to exchange service specifications/catalogs and make service orders between Organizations as the following figure displays.

[![OpenSlice  Service Specification instantiation](./images/multi-domain-organizations.png)](./images/multi-domain-organizations.png)

An Identity federation is also possible since our authentication service is based on Keycloak (see [OAuth](./architecture/oauth.md)).

See more on [Consuming Services From External Partner Organizations](./architecture/consumingServicesFromExternalPartners.md).


## Live Demo

* OpenSlice demo: <http://portal.openslice.io/>
* OpenSlice Service Catalogs and ordering: <http://portal.openslice.io/services/>
* OpenSlice NFV Services onboarding: <http://portal.openslice.io/nfvportal>
> username=admin, password=openslice <br> or <br>username=admin, password=changeme


## Video demo

* <https://youtu.be/KU8JPDFFl9A>

---

## Installing

See [Deployment/Installation](./deployment.md).

---

## Hardware requirements

The complete environment consists of microservices deployed as docker containers. Portainer is also installed to monitor them at port 9000.

If you would like to operate all APIs, OSOM, the Mysql Server, nginx, etc then you need at least:

| **Minimum Hardware Requirements** | **Recomended Hardware Requirements** |
| --------------------------------- | ------------------------------------ |
| 4 CPU cores                       | 8 CPU cores                          |
| 8 GB RAM                          | 16 GB RAM                            |
| 20 GB storage                     | 40 GB storage                        |


(NOTE: Bugzilla or ELK are not included and we assume they run elsewhere)

However, you may try the front facing services of OpenSlice with a minimum installation on a VM on a laptop with:

- 2 cores
- 4GB of RAM  

 

## Supported APIs

Quick overview of the supported APIs through our Swagger links:

* [TMF APIs](http://portal.openslice.io/tmf-api/swagger-ui/index.html)
* [API for VNF/NSD management](http://portal.openslice.io/osapi/swagger-ui/index.html)

## Source code

OpenSlice source code is available at [OSL GitLab repository](https://labs.etsi.org/rep/osl/code).

## Contributing

You may contribute following the guidelines at [Contributing page](./contributing/developing.md).

## Social Media

* [Twitter](https://twitter.com/OpensliceOSS)
* [Slack](https://openslice.slack.com)

## History

* The NFV portal part of OpenSlice was initially developed in H2020 European Research project [5GinFIRE](https://5ginfire.eu) by University of Patras, Greece
* OpenSlice core services, APIs was further developed and maintained in H2020 European project [5G-VINNI](https://5g-vinni.eu/) by University of Patras, Greece
* OpenSlice has been a part off OSM's OSS/BSS ecosystem


[![Part of OSM Ecosystem](./images/osm_ecosystem_ossbss.png)](https://osm.etsi.org/wikipub/index.php/OSS_BSS)

## Ecosystem

Discover the current OpenSlice ecosystem [here](https://osl.etsi.org/ecosystem/).

## Citation

Please cite our [![paper]](https://arxiv.org/abs/2102.03290) if you use Openslice

```

@misc{tranoris2021openslice,
      title={Openslice: An opensource OSS for Delivering Network Slice as a Service}, 
      author={Christos Tranoris},
      year={2021},
      eprint={2102.03290},
      archivePrefix={arXiv},
      primaryClass={cs.NI}
}

```